<?php

namespace Modules\Communication\app\Repositories\Eloquent;

use Modules\Communication\app\Repositories\Contracts\EmailInterface;
use Modules\Communication\app\Helpers\MailConfigurator;
use Modules\Communication\app\Mail\Samplemail;
use Illuminate\Support\Facades\Mail;

class EmailRepository implements EmailInterface
{
    public function sendEmail(array $data): array
    {
        try {
            \Log::info('EmailRepository: Configuring mail');
            MailConfigurator::configureMail();
            
            \Log::info('EmailRepository: Sending email', [
                'to' => $data['to_email'],
                'subject' => $data['subject'] ?? 'N/A'
            ]);
            
            Mail::to($data['to_email'])->send(new Samplemail([
                'message' => $data['content'],
                'subject' => $data['subject'],
                'attachment' => $data['attachment'] ?? null,
            ]));

            \Log::info('EmailRepository: Email sent successfully');

            return [
                'code' => 200,
                'message' => __('Email sent successfully.'),
                'data' => []
            ];
        } catch (\Exception $e) {
            \Log::error('EmailRepository: Failed to send email', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
                'to_email' => $data['to_email'] ?? 'N/A'
            ]);
            
            return [
                'code' => 500,
                'message' => 'Failed to send email: ' . $e->getMessage(),
                'data' => []
            ];
        }
    }

    public function sendBulkEmail(array $emails, array $data): array
    {
        MailConfigurator::configureMail();
        
        foreach ($emails as $email) {
            Mail::to($email)->send(new Samplemail([
                'message' => $data['content'],
                'subject' => $data['subject'],
                'attachment' => $data['attachment'] ?? null,
            ]));
        }

        return [
            'code' => 200,
            'message' => __('Bulk emails sent successfully.'),
            'data' => []
        ];
    }
}