<?php

use Illuminate\Support\Facades\Route;
use Modules\Communication\app\Http\Controllers\CommunicationController;
use Modules\Communication\app\Http\Controllers\EmailController;
use Modules\Communication\app\Http\Controllers\SmsController;
// NotificationController removed - Firebase/push notifications disabled
/*
 *--------------------------------------------------------------------------
 * API Routes
 *--------------------------------------------------------------------------
 *
 * Here is where you can register API routes for your application. These
 * routes are loaded by the RouteServiceProvider within a group which
 * is assigned the "api" middleware group. Enjoy building your API!
 *
*/

Route::prefix('mail')->group(function () {
    Route::post('/sendmail', [EmailController::class, 'sendEmail']);
});
Route::prefix('sms')->group(function () {
    Route::post('/sendsms', [SmsController::class, 'sendOtpSms']);
    Route::post('/getmsgserviceid',[SmsController::class, 'getmsgserviceid']);
});
// Notification routes removed - Firebase/push notifications disabled

Route::post('/otp-settingsapi', [CommunicationController::class, 'getOtpSettingsApi']);
Route::post('/verify-otp-api', [CommunicationController::class, 'verifyOtpApi']);
