<?php

namespace Modules\Leads\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;

class Payments extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'payments';

    protected $fillable = ['id', 'payment_date', 'payment_type', 'user_type','user_id','amount','transaction_id','status', 'reference_id', 'created_at', 'created_by', 'updated_at', 'updated_by', 'deleted_at', 'deleted_by'];

    protected $casts = [
        'amount' => 'decimal:2',
        'payment_date' => 'date',
    ];

    /**
     * Get the user who made this payment
     *
     * @return BelongsTo<User, Payments>
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get the user form input (lead) this payment is for
     *
     * @return BelongsTo<UserFormInput, Payments>
     */
    public function userFormInput(): BelongsTo
    {
        return $this->belongsTo(UserFormInput::class, 'reference_id');
    }

    /**
     * Get the user who created this payment record
     *
     * @return BelongsTo<User, Payments>
     */
    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the user who updated this payment record
     *
     * @return BelongsTo<User, Payments>
     */
    public function updatedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
