<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * Adds performance indexes to the user_form_inputs table
     * to optimize common query patterns in the leads system.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('user_form_inputs', function (Blueprint $table) {
            // Composite indexes for common query patterns
            $table->index(['lead_source', 'marketplace_status'], 'idx_lead_source_status');
            $table->index(['category_id', 'marketplace_status'], 'idx_category_status');
            $table->index(['user_id', 'lead_source'], 'idx_user_source');
            $table->index(['is_unlocked', 'marketplace_status'], 'idx_unlocked_status');
            $table->index(['quality_score', 'marketplace_status'], 'idx_quality_status');
            $table->index(['calculated_unlock_price', 'marketplace_status'], 'idx_price_status');
            $table->index(['created_at', 'marketplace_status'], 'idx_created_status');
            
            // Index for provider-specific queries
            $table->index(['unlocked_by_provider_id', 'is_unlocked'], 'idx_provider_unlocked');
            
            // Index for expiry queries
            $table->index(['expires_at', 'marketplace_status'], 'idx_expires_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::table('user_form_inputs', function (Blueprint $table) {
            $table->dropIndex('idx_lead_source_status');
            $table->dropIndex('idx_category_status');
            $table->dropIndex('idx_user_source');
            $table->dropIndex('idx_unlocked_status');
            $table->dropIndex('idx_quality_status');
            $table->dropIndex('idx_price_status');
            $table->dropIndex('idx_created_status');
            $table->dropIndex('idx_provider_unlocked');
            $table->dropIndex('idx_expires_status');
        });
    }
};
