@extends('admin.layouts.app')

@section('title', __('Lead Pricing'))

@section('content')
<div class="page-wrapper page-settings">
    <div class="content">
        <div class="content-page-header content-page-headersplit">
            <h5>{{ __('Lead Pricing') }}</h5>
            <div class="list-btn">
                <ul>
                    <li>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPricingModal">
                            <i class="fa fa-plus me-2"></i>{{ __('Add Pricing Rule') }}
                        </button>
                    </li>
                    <li>
                        <button class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#templateModal">
                            <i class="fa fa-clone me-2"></i>{{ __('Apply Template') }}
                        </button>
                    </li>
                    <li>
                        <button class="btn btn-info" data-bs-toggle="modal" data-bs-target="#testCalculatorModal">
                            <i class="fa fa-calculator me-2"></i>{{ __('Test Calculator') }}
                        </button>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Info Alert -->
        <div class="alert alert-info alert-dismissible fade show" role="alert">
            <strong><i class="fa fa-info-circle me-2"></i>{{ __('How Lead Pricing Works') }}</strong>
            <p class="mb-0 mt-2">
                {{ __('Set unlock prices for each category based on:') }}
                <br>• <strong>{{ __('Base Price') }}:</strong> {{ __('Starting price for any lead') }}
                <br>• <strong>{{ __('Price Per Field') }}:</strong> {{ __('Added for each field filled by the client') }}
                <br>• <strong>{{ __('Price Per 100 Characters') }}:</strong> {{ __('Added for message length') }}
                <br>• <strong>{{ __('Min/Max Price') }}:</strong> {{ __('Caps to prevent extreme values') }}
            </p>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>

        <!-- Filters -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="input-block mb-3">
                                    <label>{{ __('Search') }}</label>
                                    <input type="text" class="form-control" id="searchFilter" placeholder="{{ __('Search by category name...') }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="input-block mb-3">
                                    <label>{{ __('Status') }}</label>
                                    <select class="form-select" id="statusFilter">
                                        <option value="">{{ __('All Status') }}</option>
                                        <option value="1">{{ __('Active') }}</option>
                                        <option value="0">{{ __('Inactive') }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="input-block mb-3">
                                    <label>&nbsp;</label>
                                    <div>
                                        <button type="button" class="btn btn-primary" id="btnApplyFilter">
                                            <i class="fa fa-search me-2"></i>{{ __('Search') }}
                                        </button>
                                        <button type="button" class="btn btn-secondary" id="btnResetFilter">
                                            <i class="fa fa-refresh me-2"></i>{{ __('Reset') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pricing Rules Table -->
        <div class="row">
            <div class="col-12">
                <div class="table-resposnive table-div">
                    <table class="table datatable" id="pricingTable">
                        <thead>
                            <tr>
                                <th>{{ __('Category') }}</th>
                                <th>{{ __('Base Price') }}</th>
                                <th>{{ __('Price/Field') }}</th>
                                <th>{{ __('Price/100 Chars') }}</th>
                                <th>{{ __('Min Price') }}</th>
                                <th>{{ __('Max Price') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Created By') }}</th>
                                <th>{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Loaded via AJAX -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add/Edit Pricing Modal -->
<div class="modal fade" id="addPricingModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="pricingForm">
                <input type="hidden" id="pricing_id" name="pricing_id">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">{{ __('Add Pricing Rule') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="category_id" class="form-label">{{ __('Category') }} *</label>
                            <select class="form-select" id="category_id" name="category_id" required>
                                <option value="">{{ __('Select Category') }}</option>
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="base_price" class="form-label">{{ __('Base Price') }} (Credits) *</label>
                            <input type="number" step="0.01" min="0" max="10000" class="form-control" id="base_price" name="base_price" required>
                            <small class="text-muted">{{ __('Starting price for any lead') }}</small>
                            <div class="invalid-feedback"></div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="price_per_field" class="form-label">{{ __('Price Per Field') }} (Credits) *</label>
                            <input type="number" step="0.01" min="0" max="100" class="form-control" id="price_per_field" name="price_per_field" required>
                            <small class="text-muted">{{ __('Added per filled field') }}</small>
                            <div class="invalid-feedback"></div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="price_per_100_chars" class="form-label">{{ __('Price Per 100 Characters') }} (Credits) *</label>
                            <input type="number" step="0.01" min="0" max="100" class="form-control" id="price_per_100_chars" name="price_per_100_chars" required>
                            <small class="text-muted">{{ __('Added per 100 message chars') }}</small>
                            <div class="invalid-feedback"></div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">&nbsp;</label>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="active" name="active" checked>
                                <label class="form-check-label" for="active">
                                    {{ __('Active') }}
                                </label>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="min_price" class="form-label">{{ __('Minimum Price') }} (Credits) *</label>
                            <input type="number" step="0.01" min="0" max="10000" class="form-control" id="min_price" name="min_price" required>
                            <small class="text-muted">{{ __('Lowest possible price') }}</small>
                            <div class="invalid-feedback"></div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="max_price" class="form-label">{{ __('Maximum Price') }} (Credits) *</label>
                            <input type="number" step="0.01" min="0" max="10000" class="form-control" id="max_price" name="max_price" required>
                            <small class="text-muted">{{ __('Highest possible price') }}</small>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>

                    <!-- Price Preview -->
                    <div class="alert alert-secondary mt-3" id="pricePreview" style="display: none;">
                        <h6 class="mb-2">{{ __('Price Preview') }}:</h6>
                        <div id="previewContent"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary" id="btnSavePricing">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">{{ __('Save') }}</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Apply Template Modal -->
<div class="modal fade" id="templateModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="templateForm">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Apply Pricing Template') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('Select Template') }} *</label>
                        <select class="form-select" id="template_type" name="template" required>
                            <option value="">{{ __('Choose template...') }}</option>
                            <option value="low">{{ __('Low Value') }} (5-25 Credits)</option>
                            <option value="medium">{{ __('Medium Value') }} (10-50 Credits)</option>
                            <option value="high">{{ __('High Value') }} (20-100 Credits)</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">{{ __('Select Categories') }} *</label>
                        <select class="form-select" id="template_categories" name="category_ids[]" multiple required size="8">
                            <!-- Loaded via AJAX -->
                        </select>
                        <small class="text-muted">{{ __('Hold Ctrl to select multiple') }}</small>
                    </div>

                    <div class="alert alert-info">
                        <strong>{{ __('Template Details') }}:</strong>
                        <div id="templateDetails"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary" id="btnApplyTemplate">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">{{ __('Apply Template') }}</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Test Calculator Modal -->
<div class="modal fade" id="testCalculatorModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="testCalculatorForm">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Test Price Calculator') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('Category') }} *</label>
                        <select class="form-select" id="test_category_id" name="category_id" required>
                            <option value="">{{ __('Select Category') }}</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">{{ __('Fields Filled') }} *</label>
                        <input type="number" class="form-control" id="test_fields_filled" name="fields_filled" min="0" max="20" value="8" required>
                        <small class="text-muted">{{ __('Number of form fields filled (0-20)') }}</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">{{ __('Message Characters') }} *</label>
                        <input type="number" class="form-control" id="test_message_chars" name="message_chars" min="0" max="2000" value="300" required>
                        <small class="text-muted">{{ __('Message length (0-2000)') }}</small>
                    </div>

                    <div class="alert alert-success" id="calculationResult" style="display: none;">
                        <h6 class="mb-2">{{ __('Calculation Result') }}:</h6>
                        <div id="calculationDetails"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button type="submit" class="btn btn-primary" id="btnCalculate">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">{{ __('Calculate') }}</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script src="{{ asset('assets/js/admin-lead-pricing.js') }}"></script>
@endpush

