@extends('admin.admin')

@section('title', __('Submitted Requests'))

@push('styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables/css/jquery.dataTables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables/css/responsive.dataTables.min.css') }}">
<style>
    .request-card {
        transition: all 0.3s ease;
        border: 1px solid #e3e6f0;
    }
    .request-card:hover {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        transform: translateY(-2px);
    }
    .status-badge {
        font-size: 0.75rem;
        padding: 0.375rem 0.75rem;
    }
    .provider-card {
        border: 1px solid #e3e6f0;
        border-radius: 0.5rem;
        padding: 1rem;
        margin-bottom: 1rem;
    }
    .provider-avatar {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        object-fit: cover;
    }
    .interest-level {
        font-size: 0.875rem;
    }
</style>
@endpush

@section('content')
<div class="page-wrapper">
    <div class="content pb-4">
        <!-- Page Header -->
        <div class="d-md-flex d-block align-items-center justify-content-between mb-3 pb-3 border-bottom position-relative">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('Submitted Requests') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('user.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ __('Submitted Requests') }}
                        </li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Total Requests') }}</h6>
                                <h4 class="mb-0 text-primary" id="totalRequests">0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-file-alt fa-2x text-primary opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Providers Interested') }}</h6>
                                <h4 class="mb-0 text-success" id="interestedProviders">0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-users fa-2x text-success opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Connected') }}</h6>
                                <h4 class="mb-0 text-info" id="connectedProviders">0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-handshake fa-2x text-info opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Completed') }}</h6>
                                <h4 class="mb-0 text-warning" id="completedRequests">0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-check-circle fa-2x text-warning opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Status') }}</label>
                        <select class="form-select" id="statusFilter">
                            <option value="">{{ __('All Status') }}</option>
                            <option value="pending">{{ __('Pending') }}</option>
                            <option value="unlocked">{{ __('Unlocked') }}</option>
                            <option value="in_progress">{{ __('In Progress') }}</option>
                            <option value="completed">{{ __('Completed') }}</option>
                            <option value="expired">{{ __('Expired') }}</option>
                            <option value="cancelled">{{ __('Cancelled') }}</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Category') }}</label>
                        <select class="form-select" id="categoryFilter">
                            <option value="">{{ __('All Categories') }}</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Date Range') }}</label>
                        <select class="form-select" id="dateFilter">
                            <option value="">{{ __('All Time') }}</option>
                            <option value="today">{{ __('Today') }}</option>
                            <option value="week">{{ __('This Week') }}</option>
                            <option value="month">{{ __('This Month') }}</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Search') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="searchInput" placeholder="{{ __('Search requests...') }}">
                            <button class="btn btn-outline-secondary" type="button" id="searchBtn">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Requests List -->
        <div class="row" id="requestsGrid">
            <!-- Requests will be loaded here -->
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-center mt-4">
            <nav id="paginationNav">
                <!-- Pagination will be loaded here -->
            </nav>
        </div>
    </div>
</div>

<!-- Request Details Modal -->
<div class="modal fade" id="requestDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Request Details') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="requestDetailsContent">
                <!-- Request details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                <button type="button" class="btn btn-danger" id="cancelRequestBtn" style="display: none;">
                    <i class="fas fa-times me-1"></i>{{ __('Cancel Request') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Interested Providers Modal -->
<div class="modal fade" id="providersModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Interested Providers') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="providersContent">
                <!-- Providers will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Connection Response Modal -->
<div class="modal fade" id="connectionResponseModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Provider Connection') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="connectionProviderInfo">
                    <!-- Provider info will be loaded here -->
                </div>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-1"></i>
                    {{ __('This provider has shown interest in your request and wants to connect with you.') }}
                </div>
                <div class="mb-3">
                    <label class="form-label">{{ __('Message (Optional)') }}</label>
                    <textarea class="form-control" id="connectionMessage" rows="3" placeholder="{{ __('Add a message for the provider...') }}"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                <button type="button" class="btn btn-danger me-2" id="declineConnectionBtn">
                    <i class="fas fa-times me-1"></i>{{ __('Decline') }}
                </button>
                <button type="button" class="btn btn-success" id="acceptConnectionBtn">
                    <i class="fas fa-check me-1"></i>{{ __('Accept') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Cancel Request Confirmation Modal -->
<div class="modal fade" id="cancelConfirmModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Cancel Request') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>{{ __('Are you sure you want to cancel this request?') }}</p>
                <p class="text-muted">{{ __('This action cannot be undone. Any providers who have unlocked this lead will be notified.') }}</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('No, Keep Request') }}</button>
                <button type="button" class="btn btn-danger" id="confirmCancelBtn">
                    <i class="fas fa-times me-1"></i>{{ __('Yes, Cancel Request') }}
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('assets/plugins/datatables/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('assets/js/client-submitted-requests.js') }}"></script>
@endpush
