@extends('admin.admin')

@section('content')
<div class="page-wrapper notes-page-wrapper">
    <div class="content pb-4">
        <div
            class="d-md-flex d-block align-items-center justify-content-between mb-3 pb-3 -bottom position-relative">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('LeadsInfo')}}
                </h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item">
                            {{ __('Leads')}}
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ __('LeadsInfo')}}
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex my-xl-auto right-content align-items-center flex-wrap">
                <div class="mb-2">
                    <a href="{{ route('admin.leads') }}" class="btn btn-primary d-flex align-items-center">{{ __('Back')}}</a>
                </div>
            </div>
        </div>
        <div class="row">

            <div class="col-xl-12 budget-role-notes">
                <div class="tab-content" id="v-pills-tabContent">
                    <div class="tab-pane fade active show" id="v-pills-profile" role="tabpanel"
                        aria-labelledby="v-pills-profile-tab">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="content p-0">
                                    <div class="row">
                                        <div class="col-12">
                                            <div>
                                                <div class="card">
                                                    <div class="card-header">
                                                        <div class="row align-items-center">
                                                            <div class="col-md-4">
                                                                <div class="d-flex align-items-center">
                                                                    <h4 class="username me-2"></h4>
                                                                    <p class="badge bg-outline-danger d-inline-flex align-items-center mb-0 status">
                                                                        <i class="fas fa-circle fs-6 me-1"></i>
                                                                    </p>
                                                                </div>
                                                                <div class="d-flex justify-content-start">
                                                                    <i class="ti ti-calendar mt-2 me-1"></i><p class="times mt-1 "></p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="card">
                                                                    <div class="card-body p-0">
                                                                        <p class="category mb-2 mt-2 d-flex justify-content-center"></p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="card">
                                                                    <div class="card-body p-0">
                                                                    <p class="mb-2 mt-2 d-flex justify-content-center sub_category"></p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card-body lead-design">
                                                        <div class="">
                                                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                                                <li class="nav-item" role="presentation">
                                                                    <button class="nav-link active" id="details-tab" data-bs-toggle="tab" data-bs-target="#details" type="button" role="tab" aria-controls="details" aria-selected="true">
                                                                        {{ __('Request Info') }}
                                                                    </button>
                                                                </li>
                                                                <li class="nav-item" role="presentation">
                                                                    <button class="nav-link" id="questions-tab" data-bs-toggle="tab" data-bs-target="#questions" type="button" role="tab" aria-controls="questions" aria-selected="false">
                                                                        {{ __('Questions Answered') }}
                                                                    </button>
                                                                </li>
                                                                <li class="nav-item" role="presentation">
                                                                    <button class="nav-link provider_list" id="attachments-tab" data-bs-toggle="tab" data-bs-target="#attachments" type="button" role="tab" aria-controls="attachments" aria-selected="false">
                                                                        {{ __('Provider')}}
                                                                    </button>
                                                                </li>

                                                            </ul>
                                                            <div class="tab-content" id="myTabContent">
                                                                <div class="tab-pane fade show active p-3" id="details" role="tabpanel" aria-labelledby="details-tab">
                                                                    <div class="category-info">
                                                                        <div class="row" id="form-inputs"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade p-3" id="attachments" role="tabpanel" aria-labelledby="attachments-tab">
                                                                    <div class="mt-2" id="provider-cards-container"></div>
                                                                    <div class="tabs">
                                                                        <ul class="nav nav-tabs">
                                                                            <li class="nav-item">
                                                                                <a class="nav-link active" id="new-tab" data-bs-toggle="tab" href="#new-tab-content">{{ __('New')}}</a>
                                                                            </li>
                                                                            <li class="nav-item">
                                                                                <a class="nav-link" id="accepted-tab" data-bs-toggle="tab" href="#accepted-tab-content">{{ __('Accepted')}}</a>
                                                                            </li>
                                                                            <li class="nav-item">
                                                                                <a class="nav-link" id="rejected-tab" data-bs-toggle="tab" href="#rejected-tab-content">{{ __('Rejected')}}</a>
                                                                            </li>
                                                                        </ul>
                                                                        <div class="tab-content">
                                                                            <div class="tab-pane fade show active" id="new-tab-content"></div>
                                                                            <div class="tab-pane fade" id="accepted-tab-content"></div>
                                                                            <div class="tab-pane fade" id="rejected-tab-content"></div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <div class="tab-pane fade p-3" id="questions" role="tabpanel" aria-labelledby="questions-tab">
                                                                <h6 class="mb-3">{{ __('User Answers') }}</h6>
                                                                <div id="questionResponsesContainer">
                                                                    <div class="text-center py-4">
                                                                        <div class="spinner-border text-primary" role="status">
                                                                            <span class="visually-hidden">{{ __('Loading...') }}</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-pane fade p-3" id="notes" role="tabpanel" aria-labelledby="notes-tab">
                                                                <h6 class="mb-2">Notes</h6>
                                                                <p>Add and review any important notes for this lead.</p>
                                                            </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Load question responses when the questions tab is clicked
    $('#questions-tab').on('click', function() {
        loadQuestionResponses();
    });
    
    // Also load on page load if questions tab is active
    if ($('#questions-tab').hasClass('active')) {
        loadQuestionResponses();
    }
});

function loadQuestionResponses() {
    // Try to get lead ID from URL first, then from localStorage
    let leadId = new URLSearchParams(window.location.search).get('id');
    if (!leadId) {
        leadId = localStorage.getItem('leadId');
    }
    
    if (!leadId) {
        return;
    }

    const container = $('#questionResponsesContainer');
    container.html('<div class="text-center py-4"><div class="spinner-border text-primary"></div></div>');

    $.ajax({
        url: `/admin/leads/${leadId}/question-responses`,
        type: 'GET',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success && response.responses && response.responses.length > 0) {
                displayQuestionResponses(response.responses);
            } else {
                container.html('<p class="text-muted text-center">{{ __("No questions were answered for this request") }}</p>');
            }
        },
        error: function(xhr) {
            console.error('Error loading question responses:', xhr);
            container.html('<p class="text-danger text-center">{{ __("Error loading question responses") }}</p>');
        }
    });
}

function displayQuestionResponses(responses) {
    const container = $('#questionResponsesContainer');
    container.empty();

    responses.forEach(function(response, index) {
        const questionHtml = `
            <div class="card mb-3">
                <div class="card-body">
                    <h6 class="card-subtitle mb-2 text-muted">{{ __('Question') }} ${index + 1}</h6>
                    <p class="card-text fw-bold mb-2">${response.question.question_text}</p>
                    <div class="answer-box p-3 bg-light rounded">
                        <strong class="text-primary">{{ __('Answer:') }}</strong>
                        ${response.answer_text ? 
                            `<p class="mb-0 mt-1">${response.answer_text}</p>` : 
                            `<p class="mb-0 mt-1">${response.answer ? response.answer.answer_text : '-'}</p>`
                        }
                    </div>
                </div>
            </div>
        `;
        container.append(questionHtml);
    });
}
</script>
@endpush
