@extends('admin.admin')

@section('content')
<div class="page-wrapper notes-page-wrapper">
    <div class="content pb-4">
        <div class="d-md-flex d-block align-items-center justify-content-between mb-3">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('Lead Pricing') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.leads') }}">{{ __('Leads') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ __('Pricing Management') }}
                        </li>
                    </ol>
                </nav>
            </div>
        </div>

    <!-- Pricing Management Card -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">{{ __('Category Pricing Rules') }}</h4>
                    <div>
                        <button type="button" class="btn btn-sm btn-primary" id="btn_add_rule">
                            <i class="fa fa-plus"></i> {{ __('Add New Rule') }}
                        </button>
                        <button type="button" class="btn btn-sm btn-info" id="btn_apply_template">
                            <i class="fa fa-magic"></i> {{ __('Apply Template') }}
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-center mb-0" id="pricing_table">
                            <thead>
                                <tr>
                                    <th>{{ __('Category') }}</th>
                                    <th>{{ __('Base Price') }}</th>
                                    <th>{{ __('Price/Field') }}</th>
                                    <th>{{ __('Price/100 Chars') }}</th>
                                    <th>{{ __('Min Price') }}</th>
                                    <th>{{ __('Max Price') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    </div>
</div>

<!-- Add/Edit Pricing Rule Modal -->
<div class="modal fade" id="pricingRuleModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">{{ __('Add Pricing Rule') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="pricingRuleForm">
                @csrf
                <input type="hidden" id="rule_id" name="rule_id">
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label class="form-label">{{ __('Category') }} *</label>
                        <select class="form-control" id="category_id" name="category_id" required></select>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('Base Price') }} ($) *</label>
                                <input type="number" step="0.01" class="form-control" id="base_price" name="base_price" required min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('Price Per Field') }} ($) *</label>
                                <input type="number" step="0.01" class="form-control" id="price_per_field" name="price_per_field" required min="0">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('Price Per 100 Characters') }} ($) *</label>
                                <input type="number" step="0.01" class="form-control" id="price_per_100_chars" name="price_per_100_chars" required min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('Active') }}</label>
                                <div class="form-check form-switch">
                                    <input type="checkbox" class="form-check-input" id="active" name="active" checked>
                                    <label class="form-check-label" for="active"></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('Minimum Price') }} ($) *</label>
                                <input type="number" step="0.01" class="form-control" id="min_price" name="min_price" required min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('Maximum Price') }} ($) *</label>
                                <input type="number" step="0.01" class="form-control" id="max_price" name="max_price" required min="0">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary" id="btn_save_rule">
                        <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                        {{ __('Save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Apply Template Modal -->
<div class="modal fade" id="templateModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Apply Pricing Template') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="templateForm">
                @csrf
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label class="form-label">{{ __('Select Template') }}</label>
                        <select class="form-control" id="template_type" name="template" required>
                            <option value="low">{{ __('Low Value') }} (Base: $5, Max: $50)</option>
                            <option value="medium" selected>{{ __('Medium Value') }} (Base: $15, Max: $100)</option>
                            <option value="high">{{ __('High Value') }} (Base: $30, Max: $250)</option>
                        </select>
                    </div>
                    <div class="form-group mb-3">
                        <label class="form-label">{{ __('Select Categories') }}</label>
                        <select class="form-control" id="template_categories" name="category_ids[]" multiple size="10" required></select>
                        <small class="text-muted">{{ __('Hold Ctrl/Cmd to select multiple') }}</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-success" id="btn_apply_template_submit">
                        <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                        {{ __('Apply Template') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    let pricingTable;
    let isEditMode = false;

    // Initialize DataTable
    pricingTable = $('#pricing_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("admin.leads.pricing.list") }}',
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        },
        columns: [
            { data: 'category', name: 'category' },
            { data: 'base_price', name: 'base_price' },
            { data: 'price_per_field', name: 'price_per_field' },
            { data: 'price_per_100_chars', name: 'price_per_100_chars' },
            { data: 'min_price', name: 'min_price' },
            { data: 'max_price', name: 'max_price' },
            {
                data: 'active',
                name: 'active',
                render: function(data, type, row) {
                    let checked = data ? 'checked' : '';
                    return `<div class="custom-control custom-switch">
                        <input type="checkbox" class="custom-control-input status-toggle" id="status_${row.id}" data-id="${row.id}" ${checked}>
                        <label class="custom-control-label" for="status_${row.id}"></label>
                    </div>`;
                }
            },
            {
                data: 'id',
                name: 'actions',
                orderable: false,
                searchable: false,
                render: function(data, type, row) {
                    return `
                        <button class="btn btn-sm btn-info btn-edit" data-id="${data}">
                            <i class="fa fa-edit"></i>
                        </button>
                        <button class="btn btn-sm btn-danger btn-delete" data-id="${data}">
                            <i class="fa fa-trash"></i>
                        </button>
                    `;
                }
            }
        ]
    });

    // Add New Rule
    $('#btn_add_rule').click(function() {
        isEditMode = false;
        $('#modalTitle').text('{{ __("Add Pricing Rule") }}');
        $('#pricingRuleForm')[0].reset();
        $('#rule_id').val('');
        loadAvailableCategories();
        let modal = new bootstrap.Modal(document.getElementById('pricingRuleModal'));
        modal.show();
    });

    // Edit Rule
    $(document).on('click', '.btn-edit', function() {
        isEditMode = true;
        let ruleId = $(this).data('id');
        $('#modalTitle').text('{{ __("Edit Pricing Rule") }}');
        
        $.get(`/admin/leads/pricing/${ruleId}`, function(response) {
            if (response.success) {
                let rule = response.data;
                $('#rule_id').val(rule.id);
                $('#category_id').html(`<option value="${rule.category_id}" selected>${rule.category.name}</option>`);
                $('#base_price').val(rule.base_price);
                $('#price_per_field').val(rule.price_per_field);
                $('#price_per_100_chars').val(rule.price_per_100_chars);
                $('#min_price').val(rule.min_price);
                $('#max_price').val(rule.max_price);
                $('#active').prop('checked', rule.active);
                let modal = new bootstrap.Modal(document.getElementById('pricingRuleModal'));
                modal.show();
            }
        });
    });

    // Save Rule
    $('#pricingRuleForm').submit(function(e) {
        e.preventDefault();
        let ruleId = $('#rule_id').val();
        let url = isEditMode ? `/admin/leads/pricing/${ruleId}` : '{{ route("admin.leads.pricing.store") }}';
        let method = isEditMode ? 'PUT' : 'POST';
        
        // Show loading state
        let $saveBtn = $('#btn_save_rule');
        let $spinner = $saveBtn.find('.spinner-border');
        $saveBtn.prop('disabled', true);
        $spinner.removeClass('d-none');
        
        let formData = {
            category_id: $('#category_id').val(),
            base_price: $('#base_price').val(),
            price_per_field: $('#price_per_field').val(),
            price_per_100_chars: $('#price_per_100_chars').val(),
            min_price: $('#min_price').val(),
            max_price: $('#max_price').val(),
            active: $('#active').is(':checked') ? 1 : 0,
            _token: $('meta[name="csrf-token"]').attr('content')
        };

        $.ajax({
            url: url,
            type: method,
            data: formData,
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    let modal = bootstrap.Modal.getInstance(document.getElementById('pricingRuleModal'));
                    modal.hide();
                    pricingTable.ajax.reload();
                    loadTestCategories();
                }
            },
            error: function(xhr) {
                let message = xhr.responseJSON?.message || '{{ __("An error occurred") }}';
                toastr.error(message);
            },
            complete: function() {
                // Reset button state
                $saveBtn.prop('disabled', false);
                $spinner.addClass('d-none');
            }
        });
    });

    // Delete Rule
    $(document).on('click', '.btn-delete', function() {
        let ruleId = $(this).data('id');
        
        if (confirm('{{ __("Are you sure you want to delete this pricing rule?") }}')) {
            $.ajax({
                url: `/admin/leads/pricing/${ruleId}`,
                type: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                        pricingTable.ajax.reload();
                        loadTestCategories();
                    }
                },
                error: function(xhr) {
                    toastr.error('{{ __("Unable to delete pricing rule") }}');
                }
            });
        }
    });

    // Toggle Status
    $(document).on('change', '.status-toggle', function() {
        let ruleId = $(this).data('id');
        
        $.ajax({
            url: `/admin/leads/pricing/${ruleId}/toggle`,
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                }
            },
            error: function(xhr) {
                toastr.error('{{ __("Unable to update status") }}');
                $(this).prop('checked', !$(this).prop('checked'));
            }
        });
    });

    // Apply Template
    $('#btn_apply_template').click(function() {
        loadAvailableCategories(true);
        let modal = new bootstrap.Modal(document.getElementById('templateModal'));
        modal.show();
    });

    $('#templateForm').submit(function(e) {
        e.preventDefault();
        
        // Show loading state
        let $applyBtn = $('#btn_apply_template_submit');
        let $spinner = $applyBtn.find('.spinner-border');
        $applyBtn.prop('disabled', true);
        $spinner.removeClass('d-none');
        
        let formData = {
            template: $('#template_type').val(),
            category_ids: $('#template_categories').val(),
            _token: $('meta[name="csrf-token"]').attr('content')
        };

        $.post('{{ route("admin.leads.pricing.template") }}', formData, function(response) {
            if (response.success) {
                toastr.success(response.message);
                let modal = bootstrap.Modal.getInstance(document.getElementById('templateModal'));
                modal.hide();
                pricingTable.ajax.reload();
                loadTestCategories();
            }
        }).fail(function(xhr) {
            toastr.error('{{ __("Unable to apply template") }}');
        }).always(function() {
            // Reset button state
            $applyBtn.prop('disabled', false);
            $spinner.addClass('d-none');
        });
    });

    // Load Available Categories
    function loadAvailableCategories(forTemplate = false) {
        $.get('{{ route("admin.leads.pricing.categories") }}', function(response) {
            if (response.success) {
                let targetSelect = forTemplate ? '#template_categories' : '#category_id';
                $(targetSelect).empty();
                
                if (!forTemplate) {
                    $(targetSelect).append('<option value="">{{ __("Select category...") }}</option>');
                }
                
                response.categories.forEach(function(cat) {
                    $(targetSelect).append(`<option value="${cat.id}">${cat.name}</option>`);
                });
            }
        }).fail(function(xhr) {
            console.error('Failed to load categories:', xhr);
            toastr.error('{{ __("Unable to load categories") }}');
        });
    }

});
</script>
@endpush

