<?php

use App\Http\Controllers\TransactionController;
use Illuminate\Support\Facades\Route;
use Modules\Leads\app\Http\Controllers\LeadsController;
use Modules\Leads\app\Http\Controllers\ProviderController;
use Modules\Leads\app\Http\Controllers\UserController;
use Modules\Leads\app\Http\Controllers\MarketplaceLeadController;
use Modules\Leads\app\Http\Controllers\HelpFormQuestionsController;

/*
 *--------------------------------------------------------------------------
 * API Routes
 *--------------------------------------------------------------------------
 *
 * Here is where you can register API routes for your application. These
 * routes are loaded by the RouteServiceProvider within a group which
 * is assigned the "api" middleware group. Enjoy building your API!
 *
*/

Route::middleware(['auth:sanctum'])->prefix('')->group(function () {
    Route::apiResource('leads', LeadsController::class)->names('leads');


});
// Admin routes - require admin authentication with rate limiting
Route::middleware(['auth:sanctum', 'admin.auth', 'throttle:100,1'])->group(function () {
    Route::post('/leads/admin/list', [LeadsController::class, 'formInputAdminList']);
    Route::post('/leads/admin/status', [LeadsController::class, 'formInputStatus']);
});

// Provider routes - require provider authentication with rate limiting
Route::middleware(['auth:sanctum', 'provider.auth', 'throttle:60,1'])->group(function () {
    Route::post('/update/leads', [LeadsController::class, 'updateProviderLeads']);
    Route::post('/list/leads', [LeadsController::class, 'listProviderLeads']);
    Route::post('/leads/provider/status', [LeadsController::class, 'providerFormsInpuStatus']);
    Route::post('/leads/provider/list', [LeadsController::class, 'listProviders']);
    Route::post('/provider/update-quote', [ProviderController::class, 'updateQuote']);
});

// User routes - require user authentication with rate limiting
Route::middleware(['auth:sanctum', 'throttle:30,1'])->group(function () {
    Route::post('/leads/list', [LeadsController::class, 'userList']);
    Route::post('/leads/user/store', [LeadsController::class, 'formInputUserStore']);
    Route::post('/leads/user/list', [LeadsController::class, 'formInputUserList']);
    Route::post('/leads/user/status', [UserController::class, 'userStatus']);
    Route::post('/storepayments', [LeadsController::class, 'storepayments']);
});

Route::post('/leads/transaction-list', [TransactionController::class, 'leadsTransactionList'])->middleware(['auth:sanctum', 'throttle:30,1']);

// Marketplace Lead Routes (with web middleware for session support in OTP flow)
Route::prefix('leads/request-help')->middleware(['web', 'throttle:20,1'])->group(function () {
    Route::get('/categories', [MarketplaceLeadController::class, 'getCategories']);
    Route::get('/services', [MarketplaceLeadController::class, 'getServices']);
    Route::get('/calculate-price', [MarketplaceLeadController::class, 'calculatePrice']);
    Route::post('/submit', [MarketplaceLeadController::class, 'submit']);
    Route::post('/verify-otp', [MarketplaceLeadController::class, 'verifyOtpAndSubmit']);
    Route::post('/resend-otp', [MarketplaceLeadController::class, 'resendOtp']);
});

// User Requests API (using web auth for session-based authentication)
Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/leads/user-requests', [MarketplaceLeadController::class, 'getUserRequests']);
});

// Help Form Questions API (public endpoint for form submission)
Route::get('/leads/help-form/questions', [HelpFormQuestionsController::class, 'getActiveQuestions'])->middleware('throttle:60,1');

// Lead responses require authentication (also available via web route with admin.auth)
Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/leads/{id}/question-responses', [HelpFormQuestionsController::class, 'getLeadResponses']);
});


