<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\GlobalSetting\Entities\GlobalSetting;

class ApiController extends Controller
{
    /**
     * Get Google Maps API Key for frontend use
     */
    public function getGoogleMapsKey(Request $request)
    {
        // Try general_settings table first
        $apiKey = GlobalSetting::where('key', 'goglemapkey')->value('value');
        
        // If not found, try credential_settings table
        if (!$apiKey) {
            try {
                $apiKey = DB::table('credential_settings')
                    ->where('key', 'location_api_key')
                    ->value('value');
            } catch (\Exception $e) {
                // Table doesn't exist, continue with null
            }
        }
        
        if (!$apiKey) {
            return response()->json([
                'success' => false,
                'message' => 'Google Maps API key not configured'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'api_key' => $apiKey
        ]);
    }
}
