<?php

namespace App\Http\Middleware;

use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken as Middleware;

class VerifyCsrfToken extends Middleware
{
    /**
     * The URIs that should be excluded from CSRF verification.
     *
     * @var array<int, string>
     */
    protected $except = [
        '/strip-payment-success',  // Specific Stripe payment success route
        '/webhook/stripe',         // Stripe webhook endpoint
        '/webhook/paypal',         // PayPal webhook endpoint
        '/api/webhook/*',          // API webhook endpoints
        '/payfast/notify',         // PayFast ITN (Instant Transaction Notification) endpoint
        'payfast/notify',          // PayFast ITN without leading slash
        '/payfast/*',              // All PayFast routes
        'payfast/*',               // All PayFast routes without leading slash
    ];
}

