<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Branches extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'id',
        'branch_name',
        'branch_email',
        'branch_mobile',
        'branch_image',
        'branch_address',
        'branch_country',
        'lang',
        'lat',
        'branch_state',
        'branch_city',
        'branch_zip',
        'branch_startworkhour',
        'branch_endworkhour',
        'branch_workingday',
        'branch_holiday',
        'created_by',
        'verification_status',
        'verified_by',
        'verified_at',
        'rejection_reason',
        'is_main_branch',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $casts = [
        'is_main_branch' => 'boolean',
    ];

    /**
     * Get the documents for the branch.
     */
    public function documents()
    {
        return $this->hasMany(BranchDocument::class, 'branch_id');
    }

    /**
     * Get the admin who verified the branch.
     */
    public function verifier()
    {
        return $this->belongsTo(User::class, 'verified_by');
    }

    /**
     * Get the provider who created the branch.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
