<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParadigmMarketplacePricingRule extends Model
{
    use HasFactory;

    protected $fillable = [
        'rule_name',
        'paradigm_type',
        'min_score',
        'max_score',
        'price_credits',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'min_score' => 'decimal:2',
        'max_score' => 'decimal:2',
        'price_credits' => 'decimal:2',
        'is_active' => 'boolean',
    ];
}

