<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ParadigmPractitionerTransfer extends Model
{
    use HasFactory;

    protected $fillable = [
        'marketplace_purchase_id',
        'from_practitioner_id',
        'to_practitioner_id',
        'transfer_price',
        'transfer_status',
        'wallet_transaction_id_from',
        'wallet_transaction_id_to',
        'transferred_at',
    ];

    protected $casts = [
        'transfer_price' => 'decimal:2',
        'transferred_at' => 'datetime',
    ];

    /**
     * Get the marketplace purchase
     */
    public function marketplacePurchase(): BelongsTo
    {
        return $this->belongsTo(ParadigmMarketplacePurchase::class, 'marketplace_purchase_id');
    }

    /**
     * Get the from practitioner
     */
    public function fromPractitioner(): BelongsTo
    {
        return $this->belongsTo(User::class, 'from_practitioner_id');
    }

    /**
     * Get the to practitioner
     */
    public function toPractitioner(): BelongsTo
    {
        return $this->belongsTo(User::class, 'to_practitioner_id');
    }

    /**
     * Get wallet transaction for from practitioner (credit)
     */
    public function walletTransactionFrom(): BelongsTo
    {
        return $this->belongsTo(WalletHistory::class, 'wallet_transaction_id_from');
    }

    /**
     * Get wallet transaction for to practitioner (debit)
     */
    public function walletTransactionTo(): BelongsTo
    {
        return $this->belongsTo(WalletHistory::class, 'wallet_transaction_id_to');
    }

    /**
     * Complete transfer
     */
    public function complete(): void
    {
        $this->update([
            'transfer_status' => 'completed',
            'transferred_at' => now(),
        ]);
    }
}

