<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProviderDetail extends Model
{
    protected $fillable = [
        'user_id',
        'category_id',
        'subcategory_id',
    ];

    public function subcategory(): BelongsTo
    {
        return $this->belongsTo(\Modules\Categories\app\Models\Categories::class, 'subcategory_id');
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(\Modules\Categories\app\Models\Categories::class, 'category_id');
    }
}
