<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTransactionFieldsToWalletHistory extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('wallet_history', function (Blueprint $table) {
            // Check if columns don't exist before adding them
            if (!Schema::hasColumn('wallet_history', 'transaction_id')) {
                $table->string('transaction_id')->nullable()->after('status');
                $table->index('transaction_id'); // Add index for faster lookups
            }
            if (!Schema::hasColumn('wallet_history', 'reference_id')) {
                $table->string('reference_id')->nullable()->after('transaction_id');
            }
        });
        
        // Check if 'type' column is still ENUM and needs conversion
        $typeColumn = DB::select("SHOW COLUMNS FROM wallet_history WHERE Field = 'type'")[0] ?? null;
        if ($typeColumn && strpos($typeColumn->Type, 'enum') !== false) {
            // First, temporarily add a new column for the conversion
            Schema::table('wallet_history', function (Blueprint $table) {
                $table->tinyInteger('type_new')->default(1)->after('type');
            });
            
            // Copy and convert the data
            DB::statement("UPDATE wallet_history SET type_new = 1 WHERE type = 'Wallet Topup'");
            DB::statement("UPDATE wallet_history SET type_new = 2 WHERE type = 'Wallet Deduction'");
            
            // Drop old column and rename new one
            Schema::table('wallet_history', function (Blueprint $table) {
                $table->dropColumn('type');
            });
            
            Schema::table('wallet_history', function (Blueprint $table) {
                $table->renameColumn('type_new', 'type');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('wallet_history', function (Blueprint $table) {
            if (Schema::hasColumn('wallet_history', 'transaction_id')) {
                $table->dropIndex(['transaction_id']);
                $table->dropColumn('transaction_id');
            }
            if (Schema::hasColumn('wallet_history', 'reference_id')) {
                $table->dropColumn('reference_id');
            }
        });
    }
}
