<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * Adds self_purchased column to track user self-purchases
     * 0 = Provider bought for client (existing system)
     * 1 = User bought for themselves (new feature)
     */
    public function up(): void
    {
        Schema::table('paradigm_payments', function (Blueprint $table) {
            $table->tinyInteger('self_purchased')->default(0)->after('client_email');
            $table->index('self_purchased');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_payments', function (Blueprint $table) {
            $table->dropIndex(['self_purchased']);
            $table->dropColumn('self_purchased');
        });
    }
};

