<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('free_assessment_used')->default(false);
            $table->unsignedBigInteger('free_assessment_id')->nullable();
            
            // Add foreign key to paradigm_payments table
            $table->foreign('free_assessment_id')
                  ->references('id')
                  ->on('paradigm_payments')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['free_assessment_id']);
            $table->dropColumn(['free_assessment_used', 'free_assessment_id']);
        });
    }
};

