<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('paradigm_assessment_results', function (Blueprint $table) {
            $table->boolean('is_available_in_marketplace')->default(false)->after('completed_at');
            $table->timestamp('marketplace_listed_at')->nullable()->after('is_available_in_marketplace');
            $table->integer('marketplace_purchase_count')->default(0)->after('marketplace_listed_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_assessment_results', function (Blueprint $table) {
            $table->dropColumn(['is_available_in_marketplace', 'marketplace_listed_at', 'marketplace_purchase_count']);
        });
    }
};

