<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('paradigm_payments', function (Blueprint $table) {
            $table->string('client_name', 255)->nullable()->after('client_email');
            $table->string('client_surname', 255)->nullable()->after('client_name');
            $table->enum('client_gender', ['male', 'female', 'other', 'prefer_not_to_say'])->nullable()->after('client_surname');
            $table->date('client_dob')->nullable()->after('client_gender');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_payments', function (Blueprint $table) {
            $table->dropColumn(['client_name', 'client_surname', 'client_gender', 'client_dob']);
        });
    }
};

