<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('wallet_history', function (Blueprint $table) {
            $table->decimal('credits', 10, 2)->nullable()->after('amount')->comment('Number of credits purchased');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('wallet_history', function (Blueprint $table) {
            $table->dropColumn('credits');
        });
    }
};

