<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_questions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->constrained('paradigm_form_templates')->onDelete('cascade');
            $table->text('question_text');
            $table->string('option_a_label', 255);
            $table->string('option_b_label', 255);
            $table->string('option_c_label', 255)->nullable(); // For SERQ questions
            $table->string('option_d_label', 255)->nullable(); // For ranking questions
            $table->enum('assessment_module', [
                'balance_profile', 
                'conflict_styles', 
                'connection_styles', 
                'personality_blueprint', 
                'serq', 
                'brain_frames', 
                'brain_fields'
            ]);
            $table->string('element_key', 100)->nullable(); // Maps to specific Paradigm element
            $table->boolean('is_required')->default(true);
            $table->integer('display_order')->default(0);
            $table->timestamps();
            
            $table->index(['template_id', 'assessment_module', 'display_order'], 'paradigm_questions_template_module_order_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_questions');
    }
};