<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_personal_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->constrained('paradigm_form_templates')->onDelete('cascade');
            $table->string('field_key', 50); // name, surname, gender, age, phone, email
            $table->string('field_label', 100);
            $table->enum('field_type', ['text', 'select', 'email', 'tel', 'number'])->default('text');
            $table->boolean('is_required')->default(true);
            $table->json('options')->nullable(); // for select fields like gender, age_range
            $table->integer('display_order')->default(0);
            $table->timestamps();
            
            $table->index(['template_id', 'display_order']);
            $table->unique(['template_id', 'field_key']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_personal_fields');
    }
};