<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_pdf_elements', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('template_id');
            $table->unsignedBigInteger('page_id');
            $table->integer('page_number')->default(1);
            $table->string('element_type');
            $table->string('element_key');
            $table->text('text_template')->nullable();
            $table->decimal('x_pct', 5, 2);
            $table->decimal('y_pct', 5, 2);
            $table->decimal('w_pct', 5, 2);
            $table->integer('font_px')->default(12);
            $table->string('text_align', 20)->default('left');
            $table->integer('font_weight')->default(400);
            $table->string('color', 20)->default('#000000');
            $table->string('bg_color', 20)->default('transparent');
            $table->string('fg_color', 20)->nullable();
            $table->boolean('is_background')->default(false);
            $table->string('background_image_path')->nullable();
            $table->integer('display_order')->default(1);
            $table->timestamps();

            $table->foreign('template_id')->references('id')->on('paradigm_form_templates');
            // Note: page_id foreign key will be added in a separate migration after paradigm_pdf_pages table is created
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_pdf_elements');
    }
};