<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_assessment_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->constrained('paradigm_form_templates');
            $table->string('session_id', 255)->nullable();
            $table->string('name', 255);
            $table->string('surname', 255);
            $table->string('gender', 50)->nullable();
            $table->string('age_range', 50)->nullable();
            $table->string('phone', 50)->nullable();
            $table->string('email', 255)->nullable();
            $table->json('scores_json'); // Store all calculated scores
            $table->string('paradigm_type', 50)->nullable(); // Final Paradigm type
            $table->string('dominance_category_short', 50)->nullable(); // Short category description
            $table->json('answers_json')->nullable(); // Store all answers for reference
            $table->json('personal_data')->nullable(); // Store personal information
            
            // All 74 Paradigm Profile Elements
            // Percentage Values (23)
            $table->decimal('lu_percentage', 5, 2)->nullable();
            $table->decimal('ll_percentage', 5, 2)->nullable();
            $table->decimal('ru_percentage', 5, 2)->nullable();
            $table->decimal('rl_percentage', 5, 2)->nullable();
            $table->decimal('fact_finder_percentage', 5, 2)->nullable();
            $table->decimal('question_asker_percentage', 5, 2)->nullable();
            $table->decimal('rule_keeper_percentage', 5, 2)->nullable();
            $table->decimal('task_manager_percentage', 5, 2)->nullable();
            $table->decimal('creator_percentage', 5, 2)->nullable();
            $table->decimal('big_thinker_percentage', 5, 2)->nullable();
            $table->decimal('empath_percentage', 5, 2)->nullable();
            $table->decimal('friend_maker_percentage', 5, 2)->nullable();
            $table->decimal('extroversion_percentage', 5, 2)->nullable();
            $table->decimal('introversion_percentage', 5, 2)->nullable();
            $table->decimal('emotional_balance_percentage', 5, 2)->nullable();
            $table->decimal('spiritual_balance_percentage', 5, 2)->nullable();
            $table->decimal('physical_balance_percentage', 5, 2)->nullable();
            $table->decimal('social_balance_percentage', 5, 2)->nullable();
            $table->decimal('financial_balance_percentage', 5, 2)->nullable();
            $table->decimal('occupational_balance_percentage', 5, 2)->nullable();
            $table->decimal('intellectual_balance_percentage', 5, 2)->nullable();
            $table->decimal('environmental_balance_percentage', 5, 2)->nullable();
            $table->decimal('overall_wellness_score', 5, 2)->nullable();
            
            // Integer Score & Rank Values (20)
            $table->integer('connection_style_verbal_validator_score')->nullable();
            $table->integer('connection_style_presence_seeker_score')->nullable();
            $table->integer('connection_style_symbolic_appreciator_score')->nullable();
            $table->integer('connection_style_practical_supporter_score')->nullable();
            $table->integer('connection_style_grounded_connector_score')->nullable();
            $table->integer('conflict_style_assertive_challenger_score')->nullable();
            $table->integer('conflict_style_integrative_bridge_builder_score')->nullable();
            $table->integer('conflict_style_fair_negotiator_score')->nullable();
            $table->integer('conflict_style_quiet_protector_score')->nullable();
            $table->integer('conflict_style_peacekeeper_score')->nullable();
            $table->integer('connection_style_verbal_validator_rank')->nullable();
            $table->integer('connection_style_presence_seeker_rank')->nullable();
            $table->integer('connection_style_symbolic_appreciator_rank')->nullable();
            $table->integer('connection_style_practical_supporter_rank')->nullable();
            $table->integer('connection_style_grounded_connector_rank')->nullable();
            $table->integer('conflict_style_assertive_challenger_rank')->nullable();
            $table->integer('conflict_style_integrative_bridge_builder_rank')->nullable();
            $table->integer('conflict_style_fair_negotiator_rank')->nullable();
            $table->integer('conflict_style_quiet_protector_rank')->nullable();
            $table->integer('conflict_style_peacekeeper_rank')->nullable();
            
            // User & Report Information (8)
            $table->string('user_full_name', 255)->nullable();
            $table->string('report_date', 50)->nullable();
            $table->string('user_gender', 50)->nullable();
            $table->string('user_age_range', 50)->nullable();
            $table->string('practitioner_name', 255)->nullable();
            $table->string('practitioner_email', 255)->nullable();
            $table->string('practitioner_phone', 50)->nullable();
            $table->string('practitioner_url', 255)->nullable();
            
            // Profile Types & Labels (6)
            $table->string('lu_preference_level', 50)->nullable();
            $table->string('ll_preference_level', 50)->nullable();
            $table->string('ru_preference_level', 50)->nullable();
            $table->string('rl_preference_level', 50)->nullable();
            
            // Ranked Style Names (10)
            $table->string('connection_style_rank_1_name', 100)->nullable();
            $table->string('connection_style_rank_2_name', 100)->nullable();
            $table->string('connection_style_rank_3_name', 100)->nullable();
            $table->string('connection_style_rank_4_name', 100)->nullable();
            $table->string('connection_style_rank_5_name', 100)->nullable();
            $table->string('conflict_style_rank_1_name', 100)->nullable();
            $table->string('conflict_style_rank_2_name', 100)->nullable();
            $table->string('conflict_style_rank_3_name', 100)->nullable();
            $table->string('conflict_style_rank_4_name', 100)->nullable();
            $table->string('conflict_style_rank_5_name', 100)->nullable();
            
            // Quotient Levels (3)
            $table->string('sq_level', 50)->nullable();
            $table->string('eq_level', 50)->nullable();
            $table->string('rq_level', 50)->nullable();
            
            // Conditional Booleans (4)
            $table->boolean('is_single_frame')->default(false);
            $table->boolean('is_dual_frame')->default(false);
            $table->boolean('is_triple_frame')->default(false);
            $table->boolean('is_all_frame')->default(false);
            
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
            
            $table->index(['template_id', 'completed_at']);
            $table->index(['session_id']);
            $table->index(['paradigm_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_assessment_results');
    }
};