<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('paradigm_form_templates', function (Blueprint $table) {
            $table->string('shortcode_id')->nullable()->after('name');
            $table->index('shortcode_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_form_templates', function (Blueprint $table) {
            $table->dropIndex(['shortcode_id']);
            $table->dropColumn('shortcode_id');
        });
    }
};
