<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('paradigm_pdf_elements', function (Blueprint $table) {
            // Add CSS support columns
            $table->json('css_classes')->nullable()->after('is_background');
            $table->text('css_styles')->nullable()->after('css_classes');
            $table->string('css_selector')->nullable()->after('css_styles');
            $table->string('css_id')->nullable()->after('css_selector');
            
            // Add modern positioning support
            $table->string('grid_area')->nullable()->after('css_id');
            $table->string('flex_direction')->nullable()->after('grid_area');
            $table->string('justify_content')->nullable()->after('flex_direction');
            $table->string('align_items')->nullable()->after('justify_content');
            
            // Add responsive design support
            $table->json('responsive_styles')->nullable()->after('align_items');
            
            // Add animation support
            $table->string('animation')->nullable()->after('responsive_styles');
            $table->string('transition')->nullable()->after('animation');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_pdf_elements', function (Blueprint $table) {
            $table->dropColumn([
                'css_classes',
                'css_styles', 
                'css_selector',
                'css_id',
                'grid_area',
                'flex_direction',
                'justify_content',
                'align_items',
                'responsive_styles',
                'animation',
                'transition'
            ]);
        });
    }
};
