<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update the enum to include all Paradigm Profile element types
        DB::statement("ALTER TABLE paradigm_pdf_elements MODIFY COLUMN element_type ENUM(
            'text', 
            'number', 
            'pill', 
            'image',
            'paradigm_personality_type', 
            'paradigm_type_description', 
            'paradigm_badges',
            'paradigm_name', 
            'paradigm_email', 
            'paradigm_gender', 
            'paradigm_age', 
            'paradigm_phone',
            'paradigm_personal_name', 
            'paradigm_personal_email', 
            'paradigm_personal_gender', 
            'paradigm_personal_age', 
            'paradigm_personal_phone',
            'paradigm_score_emotional_balance', 
            'paradigm_score_spiritual_balance', 
            'paradigm_score_physical_balance',
            'paradigm_score_social_balance', 
            'paradigm_score_financial_balance', 
            'paradigm_score_occupational_balance',
            'paradigm_score_intellectual_balance', 
            'paradigm_score_environmental_balance', 
            'paradigm_score_overall_wellness',
            'paradigm_assessment_date', 
            'paradigm_assessment_duration', 
            'paradigm_assessment_version'
        ) NOT NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to original enum
        DB::statement("ALTER TABLE paradigm_pdf_elements MODIFY COLUMN element_type ENUM('text', 'number', 'pill', 'image') NOT NULL");
    }
};
