<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('paradigm_pdf_elements', function (Blueprint $table) {
            $table->text('css_styles')->nullable()->after('display_order');
            $table->string('css_classes')->nullable()->after('css_styles');
            $table->string('css_id')->nullable()->after('css_classes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_pdf_elements', function (Blueprint $table) {
            $table->dropColumn(['css_styles', 'css_classes', 'css_id']);
        });
    }
};