<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('paradigm_questions', function (Blueprint $table) {
            $table->string('axis', 10)->nullable()->after('assessment_module');
            $table->string('a_side', 10)->nullable()->after('axis');
            $table->string('b_side', 10)->nullable()->after('a_side');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_questions', function (Blueprint $table) {
            $table->dropColumn(['axis', 'a_side', 'b_side']);
        });
    }
};
