<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_answer_options', function (Blueprint $table) {
            $table->id();
            $table->foreignId('question_id')->constrained('paradigm_questions')->onDelete('cascade');
            $table->text('option_text');
            $table->integer('option_order'); // 1, 2, 3, 4 for part1; 1, 2 for part2
            $table->enum('quadrant_mapping', ['LU', 'LL', 'RU', 'RL'])->nullable(); // For part1 questions
            $table->string('field_mapping')->nullable(); // For part2 questions (Analyst, Organizer, etc.)
            $table->integer('points_value')->default(1); // Points awarded for selection
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index(['question_id', 'option_order']);
            $table->index('quadrant_mapping');
            $table->index('field_mapping');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_answer_options');
    }
};
