<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('paradigm_pdf_elements', function (Blueprint $table) {
            $table->string('font_family', 50)->default('Arial')->after('font_px');
            $table->string('font_style', 20)->default('normal')->after('font_family');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_pdf_elements', function (Blueprint $table) {
            $table->dropColumn(['font_family', 'font_style']);
        });
    }
};
