<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * SAFE & BACKWARDS COMPATIBLE:
     * - Adds new columns only
     * - Default 'free' for existing records
     * - Nullable foreign key to existing wallet_history table
     * - Does NOT modify existing columns
     */
    public function up(): void
    {
        Schema::table('paradigm_payments', function (Blueprint $table) {
            // Track who paid: provider, client, or free
            $table->enum('paid_by', ['provider', 'client', 'free'])
                ->default('free')  // Existing records default to free
                ->after('status');
            
            // Link to wallet_history transaction (existing table)
            $table->foreignId('wallet_transaction_id')
                ->nullable()
                ->after('paid_by')
                ->constrained('wallet_history')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('paradigm_payments', function (Blueprint $table) {
            $table->dropForeign(['wallet_transaction_id']);
            $table->dropColumn(['paid_by', 'wallet_transaction_id']);
        });
    }
};