<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * Creates default admin user for system access
     */
    public function up(): void
    {
        // Check if admin already exists
        $adminExists = DB::table('users')
            ->where('email', 'admin@iseekhelpoffice.com')
            ->exists();

        if (!$adminExists) {
            DB::table('users')->insert([
                'name' => 'Admin User',
                'email' => 'admin@iseekhelpoffice.com',
                'password' => Hash::make('Admin@ISH2025!'),
                'email_verified_at' => now(),
                'user_type' => 1, // 1 = Admin
                'status' => 1, // Active
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('users')
            ->where('email', 'admin@iseekhelpoffice.com')
            ->delete();
    }
};
