<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * Removes soft delete functionality from leads marketplace tables.
     * System now uses hard deletes as requested.
     */
    public function up(): void
    {
        // Drop deleted_at from user_form_inputs
        if (Schema::hasColumn('user_form_inputs', 'deleted_at')) {
            Schema::table('user_form_inputs', function (Blueprint $table) {
                $table->dropColumn('deleted_at');
            });
        }

        // Drop deleted_at from lead_unlocks
        if (Schema::hasColumn('lead_unlocks', 'deleted_at')) {
            Schema::table('lead_unlocks', function (Blueprint $table) {
                $table->dropColumn('deleted_at');
            });
        }

        // Drop deleted_at from lead_pricing_rules
        if (Schema::hasColumn('lead_pricing_rules', 'deleted_at')) {
            Schema::table('lead_pricing_rules', function (Blueprint $table) {
                $table->dropColumn('deleted_at');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Restore deleted_at to user_form_inputs
        if (!Schema::hasColumn('user_form_inputs', 'deleted_at')) {
            Schema::table('user_form_inputs', function (Blueprint $table) {
                $table->softDeletes();
            });
        }

        // Restore deleted_at to lead_unlocks
        if (!Schema::hasColumn('lead_unlocks', 'deleted_at')) {
            Schema::table('lead_unlocks', function (Blueprint $table) {
                $table->softDeletes();
            });
        }

        // Restore deleted_at to lead_pricing_rules
        if (!Schema::hasColumn('lead_pricing_rules', 'deleted_at')) {
            Schema::table('lead_pricing_rules', function (Blueprint $table) {
                $table->softDeletes();
            });
        }
    }
};

