<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AddProviderIdVerificationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Check if the setting already exists
        $existingSetting = DB::table('general_settings')
            ->where('key', 'provider_id_verification_enabled')
            ->first();
        
        if ($existingSetting) {
            $this->command->info('Provider ID Verification setting already exists. Skipping...');
            return;
        }

        // Add the new setting
        DB::table('general_settings')->insert([
            'key' => 'provider_id_verification_enabled',
            'value' => '0', // Default OFF - no breaking changes
            'group_id' => 1, // General Settings group
            'created_at' => now(),
            'updated_at' => now()
        ]);

        $this->command->info('✓ Added provider_id_verification_enabled setting (default: OFF)');
        $this->command->info('');
        $this->command->info('To enable ID verification:');
        $this->command->info('Go to: Admin → Settings → General Settings');
        $this->command->info('Toggle: Provider ID Verification → ON');
    }
}

