<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\ParadigmFormTemplate;

class CompleteParadigmPart2All64QuestionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $template = ParadigmFormTemplate::where('name', 'Paradigm Profile')->first();
        if (!$template) {
            $this->command->error('Paradigm Profile template not found.');
            return;
        }
        $templateId = $template->id;

        // Clear existing Part 2 questions for this template
        DB::table('paradigm_questions')
            ->where('template_id', $templateId)
            ->where('assessment_module', 'paradigm_main')
            ->where('axis', 'paradigm_main_part2')
            ->delete();

        $part2Questions = [
            // Section 1
            ['question_text' => 'S1:Q1', 'option_a_label' => 'I enjoy being clear and direct.', 'option_b_label' => 'I like evaluating my own work and others.', 'a_side' => 'LU – The Question Asker', 'b_side' => 'LU – The Fact Finder'],
            ['question_text' => 'S1:Q2', 'option_a_label' => 'I prefer using proven methods.', 'option_b_label' => 'I like turning ideas into action.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S1:Q3', 'option_a_label' => 'I enjoy experimenting with new ideas.', 'option_b_label' => 'I sometimes enjoy thinking in unusual and imaginative ways.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Creator'],
            ['question_text' => 'S1:Q4', 'option_a_label' => 'I like being around people.', 'option_b_label' => 'I enjoy supporting others.', 'a_side' => 'RL – The Friend Maker', 'b_side' => 'RL – The Empath'],
            // Section 2
            ['question_text' => 'S2:Q1', 'option_a_label' => 'I prefer to work or study without any interruptions.', 'option_b_label' => 'I like checking every detail to see if it’s accurate.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S2:Q2', 'option_a_label' => 'I enjoy environments with structure and discipline.', 'option_b_label' => 'I prefer doing things over just thinking about them.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S2:Q3', 'option_a_label' => 'I often think ahead to what’s coming.', 'option_b_label' => 'I trust my gut, even if I don’t have all the facts.', 'a_side' => 'RU – The Big Thinker', 'b_side' => 'RU – The Creator'],
            ['question_text' => 'S2:Q4', 'option_a_label' => 'I like working in group settings.', 'option_b_label' => 'I prefer interacting with just one or two people at a time.', 'a_side' => 'RL – The Friend Maker', 'b_side' => 'RL – The Empath'],
            // Section 3
            ['question_text' => 'S3:Q1', 'option_a_label' => 'I prefer focusing on one task at a time.', 'option_b_label' => 'I like getting to the root of a problem.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S3:Q2', 'option_a_label' => 'I enjoy spaces where neatness and thoroughness are valued.', 'option_b_label' => 'I like sorting and organising thoughts or information.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S3:Q3', 'option_a_label' => 'I enjoy listening to people who talk about what’s ahead.', 'option_b_label' => 'I naturally think in visual images.', 'a_side' => 'RU – The Big Thinker', 'b_side' => 'RU – The Creator'],
            ['question_text' => 'S3:Q4', 'option_a_label' => 'I enjoy conversations with others.', 'option_b_label' => 'I like being helpful to those around me.', 'a_side' => 'RL – The Friend Maker', 'b_side' => 'RL – The Empath'],
            // Section 4
            ['question_text' => 'S4:Q1', 'option_a_label' => 'I prefer having clear goals to work toward.', 'option_b_label' => 'I like reflecting deeply on issues before acting.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S4:Q2', 'option_a_label' => 'I feel comfortable in environments that value tradition.', 'option_b_label' => 'I enjoy making plans and organising tasks.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S4:Q3', 'option_a_label' => 'I like pondering big ideas even while handling small tasks.', 'option_b_label' => 'I’m comfortable thinking on my feet.', 'a_side' => 'RU – The Big Thinker', 'b_side' => 'RU – The Creator'],
            ['question_text' => 'S4:Q4', 'option_a_label' => 'I enjoy meeting and spending time with new people.', 'option_b_label' => 'I go out of my way to show care and concern for others.', 'a_side' => 'RL – The Friend Maker', 'b_side' => 'RL – The Empath'],
            // Section 5
            ['question_text' => 'S5:Q1', 'option_a_label' => 'I like going beyond just the facts.', 'option_b_label' => 'I enjoy making sense of the facts I come across.', 'a_side' => 'LU – The Question Asker', 'b_side' => 'LU – The Fact Finder'],
            ['question_text' => 'S5:Q2', 'option_a_label' => 'I like to always be on time.', 'option_b_label' => 'I like ensuring that rules are followed.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S5:Q3', 'option_a_label' => 'I often daydream about unfamiliar places.', 'option_b_label' => 'I frequently think about where I want to be in the future.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Big Thinker'],
            ['question_text' => 'S5:Q4', 'option_a_label' => 'I like listening to everyone’s thoughts and opinions.', 'option_b_label' => 'I feel energised when I’m surrounded by others.', 'a_side' => 'RL – The Empath', 'b_side' => 'RL – The Friend Maker'],
            // Section 6
            ['question_text' => 'S6:Q1', 'option_a_label' => 'I enjoy taking things apart to explore them.', 'option_b_label' => 'I prefer staying focused on one task at a time.', 'a_side' => 'LU – The Question Asker', 'b_side' => 'LU – The Fact Finder'],
            ['question_text' => 'S6:Q2', 'option_a_label' => 'I like organising and initiating things.', 'option_b_label' => 'I enjoy working or studying in clean and tidy surroundings.', 'a_side' => 'LL – The Task Manager', 'b_side' => 'LL – The Rule Keeper'],
            ['question_text' => 'S6:Q3', 'option_a_label' => 'I love imagining things that might seem impossible.', 'option_b_label' => 'I like coming up with new ways to solve old problems.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Big Thinker'],
            ['question_text' => 'S6:Q4', 'option_a_label' => 'I value being around people who genuinely care.', 'option_b_label' => 'I learn a lot from interacting with different kinds of people.', 'a_side' => 'RL – The Empath', 'b_side' => 'RL – The Friend Maker'],
            // Section 7
            ['question_text' => 'S7:Q1', 'option_a_label' => 'I like uncovering the real cause behind a problem.', 'option_b_label' => 'I focus on what’s most important at any given time.', 'a_side' => 'LU – The Question Asker', 'b_side' => 'LU – The Fact Finder'],
            ['question_text' => 'S7:Q2', 'option_a_label' => 'I don’t mind repeating something until I get it right.', 'option_b_label' => 'I feel most comfortable in safe and secure environments.', 'a_side' => 'LL – The Task Manager', 'b_side' => 'LL – The Rule Keeper'],
            ['question_text' => 'S7:Q3', 'option_a_label' => 'I use my imagination to think outside the box.', 'option_b_label' => 'I gain new understanding by exploring different perspectives.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Big Thinker'],
            ['question_text' => 'S7:Q4', 'option_a_label' => 'I enjoy making others feel happy.', 'option_b_label' => 'I like encouraging others and boosting their confidence.', 'a_side' => 'RL – The Empath', 'b_side' => 'RL – The Friend Maker'],
            // Section 8
            ['question_text' => 'S8:Q1', 'option_a_label' => 'I like breaking down complex issues into smaller parts.', 'option_b_label' => 'Accuracy is very important to me.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S8:Q2', 'option_a_label' => 'I prefer to prepare well for meetings, exams, and tasks.', 'option_b_label' => 'I’m careful and avoid unnecessary risks.', 'a_side' => 'LL – The Task Manager', 'b_side' => 'LL – The Rule Keeper'],
            ['question_text' => 'S8:Q3', 'option_a_label' => 'I enjoy sketching or doodling while thinking or listening.', 'option_b_label' => 'I’m always searching for fresh, different approaches.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Big Thinker'],
            ['question_text' => 'S8:Q4', 'option_a_label' => 'I feel fulfilled when I can serve and support others.', 'option_b_label' => 'I prefer working in environments full of life and energy.', 'a_side' => 'RL – The Empath', 'b_side' => 'RL – The Friend Maker'],
            // Section 9
            ['question_text' => 'S9:Q1', 'option_a_label' => 'I like having clear, easy-to-follow instructions.', 'option_b_label' => 'I always want to understand the deeper meaning behind things.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S9:Q2', 'option_a_label' => 'I want others to see me as reliable and trustworthy.', 'option_b_label' => 'I enjoy following structured schedules and timetables.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S9:Q3', 'option_a_label' => 'I often imagine what the future might hold.', 'option_b_label' => 'I explain things in a way that helps others visualise them.', 'a_side' => 'RU – The Big Thinker', 'b_side' => 'RU – The Creator'],
            ['question_text' => 'S9:Q4', 'option_a_label' => 'I prefer working in a team rather than alone.', 'option_b_label' => 'I like sharing ideas with one or two close people.', 'a_side' => 'RL – The Friend Maker', 'b_side' => 'RL – The Empath'],
            // Section 10
            ['question_text' => 'S10:Q1', 'option_a_label' => 'I like knowing the exact goal or purpose before starting something.', 'option_b_label' => 'I prefer asking questions to fully understand things.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S10:Q2', 'option_a_label' => 'I value loyalty and responsibility in others.', 'option_b_label' => 'I enjoy using checklists to make sure nothing gets missed.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S10:Q3', 'option_a_label' => 'I tend to ask “Why” and “Why not” before “What” and “How.”', 'option_b_label' => 'I enjoy relaxed environments without too many rules.', 'a_side' => 'RU – The Big Thinker', 'b_side' => 'RU – The Creator'],
            ['question_text' => 'S10:Q4', 'option_a_label' => 'I like being surrounded by people I can engage with.', 'option_b_label' => 'I enjoy spending free time with those closest to me.', 'a_side' => 'RL – The Friend Maker', 'b_side' => 'RL – The Empath'],
            // Section 11
            ['question_text' => 'S11:Q1', 'option_a_label' => 'I appreciate simple, clear explanations.', 'option_b_label' => 'I like figuring out what’s right and wrong.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S11:Q2', 'option_a_label' => 'I thrive where dedication and hard work are rewarded.', 'option_b_label' => 'I prefer taking action when something needs to be done.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S11:Q3', 'option_a_label' => 'I enjoy settings where there’s variety and change.', 'option_b_label' => 'I’m drawn to doing things that break the routine.', 'a_side' => 'RU – The Big Thinker', 'b_side' => 'RU – The Creator'],
            ['question_text' => 'S11:Q4', 'option_a_label' => 'I like expanding my social circle by meeting new people.', 'option_b_label' => 'I enjoy connecting with familiar people.', 'a_side' => 'RL – The Friend Maker', 'b_side' => 'RL – The Empath'],
            // Section 12
            ['question_text' => 'S12:Q1', 'option_a_label' => 'I like ideas that are practical and meaningful.', 'option_b_label' => 'I tend to analyze and measure things before making decisions.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S12:Q2', 'option_a_label' => 'I work well with people who are committed and reliable.', 'option_b_label' => 'I like making sure everything is functioning properly.', 'a_side' => 'LL – The Rule Keeper', 'b_side' => 'LL – The Task Manager'],
            ['question_text' => 'S12:Q3', 'option_a_label' => 'I enjoy sharing my thoughts about the future.', 'option_b_label' => 'I like generating fresh, original ideas instead of recycling old ones.', 'a_side' => 'RU – The Big Thinker', 'b_side' => 'RU – The Creator'],
            ['question_text' => 'S12:Q4', 'option_a_label' => 'I enjoy being part of a positive, uplifting group.', 'option_b_label' => 'I prefer having a few deep and meaningful friendships.', 'a_side' => 'RL – The Friend Maker', 'b_side' => 'RL – The Empath'],
            // Section 13
            ['question_text' => 'S13:Q1', 'option_a_label' => 'I like doing research before reaching a final conclusion.', 'option_b_label' => 'I prefer keeping my opinions grounded and realistic.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S13:Q2', 'option_a_label' => 'I enjoy making detailed to-do lists for tasks.', 'option_b_label' => 'I like being part of environments that value tradition.', 'a_side' => 'LL – The Task Manager', 'b_side' => 'LL – The Rule Keeper'],
            ['question_text' => 'S13:Q3', 'option_a_label' => 'I often visualise what people say when they explain things.', 'option_b_label' => 'I enjoy the thrill that comes with change and progress.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Big Thinker'],
            ['question_text' => 'S13:Q4', 'option_a_label' => 'I feel driven to help those in need.', 'option_b_label' => 'I like bringing people together to talk, celebrate, or collaborate.', 'a_side' => 'RL – The Empath', 'b_side' => 'RL – The Friend Maker'],
            // Section 14
            ['question_text' => 'S14:Q1', 'option_a_label' => 'I dig deep to uncover the truth.', 'option_b_label' => 'I only like starting once I’m sure of the direction.', 'a_side' => 'LU – The Question Asker', 'b_side' => 'LU – The Fact Finder'],
            ['question_text' => 'S14:Q2', 'option_a_label' => 'I prefer reading or studying step-by-step, from beginning to end.', 'option_b_label' => 'I like visiting safe, reliable places.', 'a_side' => 'LL – The Task Manager', 'b_side' => 'LL – The Rule Keeper'],
            ['question_text' => 'S14:Q3', 'option_a_label' => 'I sometimes imagine things that don’t yet exist.', 'option_b_label' => 'I often think about how to improve the world.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Big Thinker'],
            ['question_text' => 'S14:Q4', 'option_a_label' => 'I choose to stay hopeful and positive.', 'option_b_label' => 'I enjoy being around lighthearted, easy going people.', 'a_side' => 'RL – The Empath', 'b_side' => 'RL – The Friend Maker'],
            // Section 15
            ['question_text' => 'S15:Q1', 'option_a_label' => 'I carefully examine problems before trying to solve them.', 'option_b_label' => 'I prefer setting simple, realistic goals.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S15:Q2', 'option_a_label' => 'I like overseeing tasks to ensure they stay on track.', 'option_b_label' => 'I believe in solving problems slowly but surely.', 'a_side' => 'LL – The Task Manager', 'b_side' => 'LL – The Rule Keeper'],
            ['question_text' => 'S15:Q3', 'option_a_label' => 'I work best when I have the freedom to do things my way.', 'option_b_label' => 'I enjoy new experiences and the unknown.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Big Thinker'],
            ['question_text' => 'S15:Q4', 'option_a_label' => 'I like spending time in places that feel warm and welcoming.', 'option_b_label' => 'I enjoy being social and having fun.', 'a_side' => 'RL – The Empath', 'b_side' => 'RL – The Friend Maker'],
            // Section 16
            ['question_text' => 'S16:Q1', 'option_a_label' => 'I prefer to fully understand things before moving forward.', 'option_b_label' => 'I like knowing exactly what to expect in my environment.', 'a_side' => 'LU – The Fact Finder', 'b_side' => 'LU – The Question Asker'],
            ['question_text' => 'S16:Q2', 'option_a_label' => 'I believe consistent practice leads to improvement.', 'option_b_label' => 'I value lessons learned from past experiences.', 'a_side' => 'LL – The Task Manager', 'b_side' => 'LL – The Rule Keeper'],
            ['question_text' => 'S16:Q3', 'option_a_label' => 'I enjoy thinking in unconventional and creative ways.', 'option_b_label' => 'I like finding ideas that make life better.', 'a_side' => 'RU – The Creator', 'b_side' => 'RU – The Big Thinker'],
            ['question_text' => 'S16:Q4', 'option_a_label' => 'I enjoy comforting and encouraging the people I care about.', 'option_b_label' => 'I like having a good time.', 'a_side' => 'RL – The Empath', 'b_side' => 'RL – The Friend Maker'],
        ];

        // Add common fields and insert
        foreach ($part2Questions as $i => $question) {
            $questionData = array_merge($question, [
                'template_id' => $templateId,
                'question_type' => 'part2',
                'option_c_label' => '',
                'option_d_label' => '',
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part2',
                'c_side' => '',
                'd_side' => '',
                'element_key' => 'paradigm_main_part2_q' . ($i + 1),
                'is_required' => true,
                'display_order' => $i + 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            DB::table('paradigm_questions')->insert($questionData);
        }
    }
}
