<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CreateVerificationSystemEmailTemplatesSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        // Check for existing templates and delete ONLY if they exist
        DB::table('templates')->whereIn('notification_type', [54, 55, 56, 57, 58])->delete();

        // Type 54: Staff Welcome Email (when provider creates staff)
        DB::table('templates')->insert([
            'notification_type' => 54,
            'type' => 2,
            'title' => 'Welcome to the Team',
            'subject' => 'Your Staff Account Has Been Created - {{company_name}}',
            'status' => 1,
            'created_by' => 1,
            'updated_by' => 1,
            'content' => '
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
        .button { display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .info-box { background: white; padding: 15px; border-left: 4px solid #667eea; margin: 20px 0; }
        .footer { text-align: center; margin-top: 20px; color: #666; font-size: 12px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Welcome to {{company_name}}!</h1>
        </div>
        <div class="content">
            <p>Hello <strong>{{staff_name}}</strong>,</p>
            
            <p>Your staff account has been created by {{company_name}}. Your account is currently pending verification by our admin team.</p>
            
            <div class="info-box">
                <p><strong>Email:</strong> {{staff_email}}</p>
                <p><strong>Role:</strong> {{role_name}}</p>
                <p><strong>Company:</strong> {{company_name}}</p>
            </div>
            
            <p><strong>Next Steps:</strong></p>
            <ul>
                <li>Your verification documents have been submitted to the admin team</li>
                <li>You will receive an email notification once your account is verified</li>
                <li>After verification, you can log in and start working</li>
            </ul>
            
            <p>A password reset link will be sent to your email shortly to set up your account.</p>
            
            <div class="footer">
                <p>© {{current_year}} I Seek Help International. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
</html>',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Type 55: Staff Verified Email (when admin approves)
        DB::table('templates')->insert([
            'notification_type' => 55,
            'type' => 2,
            'title' => 'Staff Account Verified',
            'subject' => 'Your Account Has Been Verified! - {{company_name}}',
            'status' => 1,
            'created_by' => 1,
            'updated_by' => 1,
            'content' => '
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
        .button { display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .success-badge { background: #10b981; color: white; padding: 5px 15px; border-radius: 20px; display: inline-block; }
        .footer { text-align: center; margin-top: 20px; color: #666; font-size: 12px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Account Verified!</h1>
        </div>
        <div class="content">
            <p>Hello <strong>{{staff_name}}</strong>,</p>
            
            <p>Great news! Your staff account has been verified and approved by the admin team.</p>
            
            <p style="text-align: center;">
                <span class="success-badge">Verified</span>
            </p>
            
            <p><strong>You can now:</strong></p>
            <ul>
                <li>Log in to your staff dashboard</li>
                <li>Access all assigned features and modules</li>
                <li>Start managing your tasks and responsibilities</li>
            </ul>
            
            <p style="text-align: center;">
                <a href="https://app.iseekhelpoffice.com" class="button">Login to Dashboard</a>
            </p>
            
            <p>If you have any questions, please contact your manager or the admin team.</p>
            
            <div class="footer">
                <p>© {{current_year}} I Seek Help International. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
</html>',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Type 56: Branch Verified Email (when admin approves)
        DB::table('templates')->insert([
            'notification_type' => 56,
            'type' => 2,
            'title' => 'Branch Verified',
            'subject' => 'Your Branch Has Been Verified! - {{branch_name}}',
            'status' => 1,
            'created_by' => 1,
            'updated_by' => 1,
            'content' => '
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
        .button { display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .success-badge { background: #10b981; color: white; padding: 5px 15px; border-radius: 20px; display: inline-block; }
        .info-box { background: white; padding: 15px; border-left: 4px solid #3b82f6; margin: 20px 0; }
        .footer { text-align: center; margin-top: 20px; color: #666; font-size: 12px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Branch Verified!</h1>
        </div>
        <div class="content">
            <p>Hello <strong>{{provider_name}}</strong>,</p>
            
            <p>Congratulations! Your branch has been verified and approved by our admin team.</p>
            
            <div class="info-box">
                <p><strong>Branch Name:</strong> {{branch_name}}</p>
                <p><strong>Location:</strong> {{branch_address}}</p>
                <p><strong>Verified On:</strong> {{verified_date}}</p>
            </div>
            
            <p style="text-align: center;">
                <span class="success-badge">Verified & Active</span>
            </p>
            
            <p><strong>Your branch is now active and you can:</strong></p>
            <ul>
                <li>Assign staff members to this branch</li>
                <li>Manage services and bookings for this location</li>
                <li>View branch-specific reports and analytics</li>
            </ul>
            
            <p style="text-align: center;">
                <a href="https://app.iseekhelpoffice.com/provider/branch" class="button">Manage Branches</a>
            </p>
            
            <div class="footer">
                <p>© {{current_year}} I Seek Help International. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
</html>',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Type 57: Admin Notification - Staff Pending Verification
        DB::table('templates')->insert([
            'notification_type' => 57,
            'type' => 2,
            'title' => 'New Staff Verification Required',
            'subject' => 'Action Required: Staff Verification Pending - {{staff_name}}',
            'status' => 1,
            'created_by' => 1,
            'updated_by' => 1,
            'content' => '
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
        .button { display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .info-box { background: white; padding: 15px; border-left: 4px solid #f59e0b; margin: 20px 0; }
        .footer { text-align: center; margin-top: 20px; color: #666; font-size: 12px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Staff Verification Required</h1>
        </div>
        <div class="content">
            <p>Hello Admin,</p>
            
            <p>A new staff member has been created and is pending your verification.</p>
            
            <div class="info-box">
                <p><strong>Staff Name:</strong> {{staff_name}}</p>
                <p><strong>Email:</strong> {{staff_email}}</p>
                <p><strong>Provider:</strong> {{company_name}}</p>
                <p><strong>Category:</strong> {{category_name}}</p>
                <p><strong>Created On:</strong> {{created_date}}</p>
            </div>
            
            <p><strong>Documents Submitted:</strong></p>
            <ul>
                <li>ID Document</li>
                <li>Selfie Photo</li>
            </ul>
            
            <p style="text-align: center;">
                <a href="https://app.iseekhelpoffice.com/admin/staff-verification" class="button">Review & Verify</a>
            </p>
            
            <div class="footer">
                <p>© {{current_year}} I Seek Help International. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
</html>',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Type 58: Admin Notification - Branch Pending Verification
        DB::table('templates')->insert([
            'notification_type' => 58,
            'type' => 2,
            'title' => 'New Branch Verification Required',
            'subject' => 'Action Required: Branch Verification Pending - {{branch_name}}',
            'status' => 1,
            'created_by' => 1,
            'updated_by' => 1,
            'content' => '
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
        .button { display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .info-box { background: white; padding: 15px; border-left: 4px solid #f59e0b; margin: 20px 0; }
        .footer { text-align: center; margin-top: 20px; color: #666; font-size: 12px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Branch Verification Required</h1>
        </div>
        <div class="content">
            <p>Hello Admin,</p>
            
            <p>A new branch has been created and is pending your verification.</p>
            
            <div class="info-box">
                <p><strong>Branch Name:</strong> {{branch_name}}</p>
                <p><strong>Address:</strong> {{branch_address}}</p>
                <p><strong>Provider:</strong> {{provider_name}}</p>
                <p><strong>Email:</strong> {{branch_email}}</p>
                <p><strong>Phone:</strong> {{branch_phone}}</p>
                <p><strong>Created On:</strong> {{created_date}}</p>
            </div>
            
            <p><strong>Documents Submitted:</strong></p>
            <ul>
                <li>Company Registration Documents</li>
                <li>Director ID</li>
                <li>Proof of Address</li>
            </ul>
            
            <p style="text-align: center;">
                <a href="https://app.iseekhelpoffice.com/admin/branch-verification" class="button">Review & Verify</a>
            </p>
            
            <div class="footer">
                <p>© {{current_year}} I Seek Help International. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
</html>',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        echo "Created 5 email templates for Branch & Staff Verification System\n";
        echo "   - Type 54: Staff Welcome Email\n";
        echo "   - Type 55: Staff Verified Email\n";
        echo "   - Type 56: Branch Verified Email\n";
        echo "   - Type 57: Admin - Staff Pending Verification\n";
        echo "   - Type 58: Admin - Branch Pending Verification\n";
    }
}

