<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\WalletHistory;
use Illuminate\Support\Facades\DB;

class CreditHayley60Seeder extends Seeder
{
    public function run()
    {
        $providerEmail = 'hayley@urbanbalancecounselling.co.za';
        $creditsToAdd = 60;
        
        $this->command->info("========================================");
        $this->command->info("CREDITING PROVIDER: {$providerEmail}");
        $this->command->info("AMOUNT: {$creditsToAdd} credits");
        $this->command->info("========================================\n");
        
        // Find provider
        $provider = User::where('email', $providerEmail)->first();
        
        if (!$provider) {
            $this->command->error("❌ Provider with email {$providerEmail} not found!");
            return;
        }
        
        $this->command->info("✅ Found Provider: {$provider->name} (ID: {$provider->id})");
        
        // Get current balance
        $totalCredits = WalletHistory::where('user_id', $provider->id)
            ->where('status', 'Completed')
            ->where('type', '1')
            ->get()
            ->sum(function($record) {
                return $record->credits ?? $record->amount;
            });
        
        $totalDebits = WalletHistory::where('user_id', $provider->id)
            ->where('status', 'Completed')
            ->where('type', '2')
            ->sum('amount');
        
        $currentBalance = $totalCredits - $totalDebits;
        $this->command->info("💰 Current Balance: {$currentBalance} credits");
        
        // Add credits to provider's wallet
        WalletHistory::create([
            'user_id' => $provider->id,
            'amount' => $creditsToAdd,
            'credits' => $creditsToAdd,
            'payment_type' => 'Others', // Valid ENUM value: Paypal, Credit Card, Bank Transfer, Others
            'status' => 'Completed',
            'transaction_id' => 'ADMIN-CREDIT-' . time(),
            'transaction_date' => now(),
            'type' => 1, // Type 1 = Credit
        ]);
        
        $this->command->info("✅ Added {$creditsToAdd} credits to provider's wallet");
        
        // Calculate new balance
        $newTotalCredits = WalletHistory::where('user_id', $provider->id)
            ->where('status', 'Completed')
            ->where('type', '1')
            ->get()
            ->sum(function($record) {
                return $record->credits ?? $record->amount;
            });
        
        $newTotalDebits = WalletHistory::where('user_id', $provider->id)
            ->where('status', 'Completed')
            ->where('type', '2')
            ->sum('amount');
        
        $newBalance = $newTotalCredits - $newTotalDebits;
        
        $this->command->info("💰 New Balance: {$newBalance} credits");
        
        // ========================================
        // SUMMARY
        // ========================================
        
        $this->command->info("\n========================================");
        $this->command->info("✅ SEEDER COMPLETED SUCCESSFULLY!");
        $this->command->info("========================================");
        $this->command->info("Provider: {$provider->name} ({$providerEmail})");
        $this->command->info("Credits Added: {$creditsToAdd}");
        $this->command->info("Previous Balance: {$currentBalance} credits");
        $this->command->info("New Balance: {$newBalance} credits");
        $this->command->info("========================================\n");
    }
}
