<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DeleteDuplicateVerificationTemplatesSeeder extends Seeder
{
    /**
     * Delete duplicate verification email templates
     * 
     * KEEP ONLY:
     * - Type 31 → ID 51 (Professional Details Verified)
     * - Type 6 → ID 5 (Identity Verification Completed)
     * 
     * DELETE:
     * - Type 31 → ID 142
     * - Type 6 → IDs 93, 102, 117
     */
    public function run(): void
    {
        $this->command->info('🗑️  Deleting duplicate verification templates...');
        $this->command->info('');
        
        try {
            DB::beginTransaction();
            
            // ============================================
            // 1. DELETE DUPLICATE PROFESSIONAL DETAILS TEMPLATES (Type 31)
            // ============================================
            $this->command->info('📧 Type 31 - Professional Details:');
            
            // Keep ID 51, delete 142
            $deleted31 = DB::table('templates')
                ->where('notification_type', 31)
                ->where('type', 1)
                ->where('id', '!=', 51)
                ->delete();
            
            if ($deleted31 > 0) {
                $this->command->info("   ✅ Deleted {$deleted31} duplicate(s)");
                $this->command->line('   ✓ Kept: ID 51 - Professional Details Verified');
            } else {
                $this->command->line('   ℹ️  No duplicates to delete');
            }
            
            $this->command->info('');
            
            // ============================================
            // 2. DELETE DUPLICATE IDENTITY VERIFICATION TEMPLATES (Type 6)
            // ============================================
            $this->command->info('📧 Type 6 - Identity Verification:');
            
            // Keep ID 5, delete 93, 102, 117
            $deleted6 = DB::table('templates')
                ->where('notification_type', 6)
                ->where('type', 1)
                ->where('id', '!=', 5)
                ->delete();
            
            if ($deleted6 > 0) {
                $this->command->info("   ✅ Deleted {$deleted6} duplicate(s)");
                $this->command->line('   ✓ Kept: ID 5 - Identity Verification Completed');
            } else {
                $this->command->line('   ℹ️  No duplicates to delete');
            }
            
            DB::commit();
            
            $this->command->info('');
            $this->command->info('========================================');
            $this->command->info('✅ All duplicate templates deleted!');
            $this->command->info('========================================');
            $this->command->info('📝 Remaining Templates:');
            $this->command->line('   • Type 31 (Professional) → ID 51');
            $this->command->line('   • Type 6 (Identity) → ID 5');
            
        } catch (\Exception $e) {
            DB::rollBack();
            $this->command->error('❌ Error: ' . $e->getMessage());
            throw $e;
        }
    }
}

