<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class FixParadigmInvitationEmailSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Update the Paradigm Invitation Email template (notification_type = 10)
        $updated = DB::table('templates')
            ->where('notification_type', 10)
            ->where('type', 1)
            ->update([
                'subject' => 'You\'ve Been Invited to Complete Your Paradigm Profile - {{company_name}}',
                'content' => $this->getFixedTemplate(),
                'updated_at' => Carbon::now(),
            ]);

        if ($updated) {
            echo "✅ Paradigm Invitation Email template updated successfully!\n";
        } else {
            echo "❌ Template not found. Creating new one...\n";
            
            // If template doesn't exist, create it
            DB::table('templates')->insert([
                'notification_type' => 10,
                'type' => 1,
                'title' => 'Paradigm Profile Invitation',
                'subject' => 'You\'ve Been Invited to Complete Your Paradigm Profile - {{company_name}}',
                'content' => $this->getFixedTemplate(),
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
            
            echo "✅ Paradigm Invitation Email template created!\n";
        }
    }

    /**
     * Get the fixed Paradigm Invitation email template
     */
    private function getFixedTemplate(): string
    {
        return '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paradigm Profile Invitation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: linear-gradient(135deg, #2c5f5d 0%, #1a3635 100%);
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 600;
        }
        .content {
            padding: 40px 30px;
        }
        .greeting {
            font-size: 22px;
            color: #2c5f5d;
            font-weight: 600;
            margin-bottom: 20px;
        }
        .message {
            font-size: 16px;
            color: #555;
            margin-bottom: 25px;
            line-height: 1.8;
        }
        .info-box {
            background-color: #f8f9fa;
            border-left: 4px solid #2c5f5d;
            padding: 20px;
            margin: 25px 0;
            border-radius: 4px;
        }
        .info-box p {
            margin: 8px 0;
            font-size: 15px;
        }
        .info-box strong {
            color: #2c5f5d;
            display: inline-block;
            min-width: 140px;
        }
        .cta-button {
            text-align: center;
            margin: 35px 0;
        }
        .cta-button a {
            display: inline-block;
            background: linear-gradient(135deg, #2c5f5d 0%, #1a3635 100%);
            color: #ffffff;
            text-decoration: none;
            padding: 16px 45px;
            border-radius: 6px;
            font-size: 18px;
            font-weight: 600;
            box-shadow: 0 4px 10px rgba(44, 95, 93, 0.3);
            transition: all 0.3s ease;
        }
        .cta-button a:hover {
            background: linear-gradient(135deg, #1a3635 0%, #0f2524 100%);
            box-shadow: 0 6px 15px rgba(44, 95, 93, 0.4);
        }
        .instructions {
            background-color: #e8f4f3;
            padding: 20px;
            border-radius: 6px;
            margin: 25px 0;
        }
        .instructions h3 {
            color: #2c5f5d;
            margin-top: 0;
            font-size: 18px;
        }
        .instructions ol {
            margin: 10px 0;
            padding-left: 25px;
        }
        .instructions li {
            margin: 8px 0;
            color: #555;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 25px;
            text-align: center;
            font-size: 13px;
            color: #666;
            border-top: 1px solid #e9ecef;
        }
        .footer p {
            margin: 5px 0;
        }
        .footer a {
            color: #2c5f5d;
            text-decoration: none;
        }
        @media only screen and (max-width: 600px) {
            .email-container {
                margin: 20px 10px;
            }
            .content {
                padding: 25px 20px;
            }
            .header h1 {
                font-size: 24px;
            }
            .greeting {
                font-size: 20px;
            }
            .cta-button a {
                padding: 14px 35px;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1>Paradigm Profile Assessment</h1>
        </div>
        
        <div class="content">
            <div class="greeting">Hello {{client_name}}!</div>
            
            <div class="message">
                You have been invited by <strong>{{provider_name}}</strong> to complete a <strong>Paradigm Profile</strong> assessment. This personalized assessment will help identify your unique profile and provide valuable insights.
            </div>
            
            <div class="info-box">
                <p><strong>Assessment:</strong> {{template_name}}</p>
                <p><strong>Provider:</strong> {{provider_name}}</p>
                <p><strong>Your Email:</strong> {{client_email}}</p>
            </div>
            
            <div class="cta-button">
                <a href="https://app.iseekhelpoffice.com" target="_blank">Login or Register to Access</a>
            </div>
            
            <div class="instructions">
                <h3>How to Get Started:</h3>
                <ol>
                    <li>Click the "Login or Register to Access" button above</li>
                    <li>Visit <strong><a href="https://app.iseekhelpoffice.com" style="color: #2c5f5d;">app.iseekhelpoffice.com</a></strong></li>
                    <li>Login with your account or register if you\'re new</li>
                    <li>Navigate to your assessments dashboard</li>
                    <li>Complete the assessment at your own pace</li>
                    <li>Review your personalized results</li>
                </ol>
            </div>
        </div>
        
        <div class="footer">
            <p><strong>{{company_name}}</strong></p>
            <p>{{company_address}}</p>
            <p>
                <a href="{{company_website}}">{{company_website}}</a> | 
                <a href="mailto:{{company_email}}">{{company_email}}</a> | 
                {{company_phone}}
            </p>
            <p style="margin-top: 15px; color: #999;">© {{company_name}} - All rights reserved</p>
        </div>
    </div>
</body>
</html>';
    }
}

