<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FixSection1Question3Seeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Update only Section 1 - Question 3 to change Option B from "RU – The Creator" to "RU – The Big Thinker"
        DB::table('paradigm_questions')
            ->where('option_b_label', 'I sometimes enjoy thinking in unusual and imaginative ways.')
            ->update([
                'b_side' => 'RU – The Big Thinker',
                'updated_at' => now()
            ]);
            
        $this->command->info('Updated Section 1 - Question 3: Option B now maps to RU – The Big Thinker');
    }
}
