<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ParadigmMainPdfElementsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first template ID and PDF page ID
        $templateId = DB::table('paradigm_form_templates')->first()->id ?? 1;
        $pageId = DB::table('paradigm_pdf_pages')->first()->id ?? 1;
        
        // Clear existing Paradigm Main elements
        DB::table('paradigm_pdf_elements')->where('template_id', $templateId)->delete();
        
        // Create the 14 Paradigm Main elements with correct column structure
        $elements = [
            // 4 Frame Scores
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_lu_score',
                'text_template' => 'LU Score: {{paradigm_main_lu_score}}',
                'x_pct' => 10.0,
                'y_pct' => 10.0,
                'w_pct' => 20.0,
                'font_px' => 14,
                'text_align' => 'left',
                'font_weight' => 700,
                'color' => '#000000',
                'bg_color' => 'transparent',
                'fg_color' => '#000000',
                'is_background' => false,
                'display_order' => 1
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_ll_score',
                'text_template' => 'LL Score: {{paradigm_main_ll_score}}',
                'x_pct' => 35.0,
                'y_pct' => 10.0,
                'w_pct' => 20.0,
                'font_px' => 14,
                'text_align' => 'left',
                'font_weight' => 700,
                'color' => '#000000',
                'bg_color' => 'transparent',
                'fg_color' => '#000000',
                'is_background' => false,
                'display_order' => 2
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_ru_score',
                'text_template' => 'RU Score: {{paradigm_main_ru_score}}',
                'x_pct' => 60.0,
                'y_pct' => 10.0,
                'w_pct' => 20.0,
                'font_px' => 14,
                'text_align' => 'left',
                'font_weight' => 700,
                'color' => '#000000',
                'bg_color' => 'transparent',
                'fg_color' => '#000000',
                'is_background' => false,
                'display_order' => 3
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_rl_score',
                'text_template' => 'RL Score: {{paradigm_main_rl_score}}',
                'x_pct' => 85.0,
                'y_pct' => 10.0,
                'w_pct' => 20.0,
                'font_px' => 14,
                'text_align' => 'left',
                'font_weight' => 700,
                'color' => '#000000',
                'bg_color' => 'transparent',
                'fg_color' => '#000000',
                'is_background' => false,
                'display_order' => 4
            ],
            
            // 8 Field Scores
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_analyst_score',
                'text_template' => 'Analyst: {{paradigm_main_analyst_score}}',
                'x_pct' => 10.0,
                'y_pct' => 20.0,
                'w_pct' => 20.0,
                'font_px' => 12,
                'text_align' => 'left',
                'font_weight' => 400,
                'color' => '#333333',
                'bg_color' => 'transparent',
                'fg_color' => '#333333',
                'is_background' => false,
                'display_order' => 5
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_organizer_score',
                'text_template' => 'Organizer: {{paradigm_main_organizer_score}}',
                'x_pct' => 35.0,
                'y_pct' => 20.0,
                'w_pct' => 20.0,
                'font_px' => 12,
                'text_align' => 'left',
                'font_weight' => 400,
                'color' => '#333333',
                'bg_color' => 'transparent',
                'fg_color' => '#333333',
                'is_background' => false,
                'display_order' => 6
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_visionary_score',
                'text_template' => 'Visionary: {{paradigm_main_visionary_score}}',
                'x_pct' => 60.0,
                'y_pct' => 20.0,
                'w_pct' => 20.0,
                'font_px' => 12,
                'text_align' => 'left',
                'font_weight' => 400,
                'color' => '#333333',
                'bg_color' => 'transparent',
                'fg_color' => '#333333',
                'is_background' => false,
                'display_order' => 7
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_helper_score',
                'text_template' => 'Helper: {{paradigm_main_helper_score}}',
                'x_pct' => 85.0,
                'y_pct' => 20.0,
                'w_pct' => 20.0,
                'font_px' => 12,
                'text_align' => 'left',
                'font_weight' => 400,
                'color' => '#333333',
                'bg_color' => 'transparent',
                'fg_color' => '#333333',
                'is_background' => false,
                'display_order' => 8
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_specialist_score',
                'text_template' => 'Specialist: {{paradigm_main_specialist_score}}',
                'x_pct' => 10.0,
                'y_pct' => 30.0,
                'w_pct' => 20.0,
                'font_px' => 12,
                'text_align' => 'left',
                'font_weight' => 400,
                'color' => '#333333',
                'bg_color' => 'transparent',
                'fg_color' => '#333333',
                'is_background' => false,
                'display_order' => 9
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_strategist_score',
                'text_template' => 'Strategist: {{paradigm_main_strategist_score}}',
                'x_pct' => 35.0,
                'y_pct' => 30.0,
                'w_pct' => 20.0,
                'font_px' => 12,
                'text_align' => 'left',
                'font_weight' => 400,
                'color' => '#333333',
                'bg_color' => 'transparent',
                'fg_color' => '#333333',
                'is_background' => false,
                'display_order' => 10
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_advisor_score',
                'text_template' => 'Advisor: {{paradigm_main_advisor_score}}',
                'x_pct' => 60.0,
                'y_pct' => 30.0,
                'w_pct' => 20.0,
                'font_px' => 12,
                'text_align' => 'left',
                'font_weight' => 400,
                'color' => '#333333',
                'bg_color' => 'transparent',
                'fg_color' => '#333333',
                'is_background' => false,
                'display_order' => 11
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_architect_score',
                'text_template' => 'Architect: {{paradigm_main_architect_score}}',
                'x_pct' => 85.0,
                'y_pct' => 30.0,
                'w_pct' => 20.0,
                'font_px' => 12,
                'text_align' => 'left',
                'font_weight' => 400,
                'color' => '#333333',
                'bg_color' => 'transparent',
                'fg_color' => '#333333',
                'is_background' => false,
                'display_order' => 12
            ],
            
            // Final Results
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_type',
                'text_template' => 'Paradigm Type: {{paradigm_main_type}}',
                'x_pct' => 10.0,
                'y_pct' => 40.0,
                'w_pct' => 40.0,
                'font_px' => 16,
                'text_align' => 'center',
                'font_weight' => 700,
                'color' => '#000000',
                'bg_color' => '#f0f0f0',
                'fg_color' => '#000000',
                'is_background' => false,
                'display_order' => 13
            ],
            [
                'template_id' => $templateId,
                'page_id' => $pageId,
                'page_number' => 1,
                'element_type' => 'text',
                'element_key' => 'paradigm_main_dominance_type',
                'text_template' => 'Dominance Type: {{paradigm_main_dominance_type}}',
                'x_pct' => 55.0,
                'y_pct' => 40.0,
                'w_pct' => 40.0,
                'font_px' => 16,
                'text_align' => 'center',
                'font_weight' => 700,
                'color' => '#000000',
                'bg_color' => '#f0f0f0',
                'fg_color' => '#000000',
                'is_background' => false,
                'display_order' => 14
            ]
        ];
        
        // Insert all elements
        foreach ($elements as $element) {
            DB::table('paradigm_pdf_elements')->insert(array_merge($element, [
                'created_at' => now(),
                'updated_at' => now()
            ]));
        }
        
        $this->command->info('Paradigm Main PDF elements seeded successfully!');
        $this->command->info('Added ' . count($elements) . ' elements to PDF builder');
    }
}