<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\ParadigmFormTemplate;

class ParadigmPart1QuestionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $template = ParadigmFormTemplate::where('name', 'Paradigm Profile')->first();
        if (!$template) {
            $this->command->error('Paradigm Profile template not found.');
            return;
        }
        $templateId = $template->id;

        DB::table('paradigm_questions')->where('template_id', $templateId)->where('assessment_module', 'paradigm_main')->where('axis', 'paradigm_main_part1')->delete();

        $part1Questions = [
            // Q1
            ['question_text' => 'When I study, I like to...', 'option_a_label' => 'get an overall view of the material', 'option_b_label' => 'memorise important facts', 'option_c_label' => 'stay positive about what I’m doing', 'option_d_label' => 'follow a set plan or method', 'a_side' => 'RU', 'b_side' => 'LU', 'c_side' => 'RL', 'd_side' => 'LL'],
            // Q2
            ['question_text' => 'I’m drawn to people who...', 'option_a_label' => 'are well-organised', 'option_b_label' => 'take a practical approach', 'option_c_label' => 'are open to different ideas', 'option_d_label' => 'really listen and pay attention to me', 'a_side' => 'LL', 'b_side' => 'LU', 'c_side' => 'RU', 'd_side' => 'RL'],
            // Q3
            ['question_text' => 'I enjoy situations that...', 'option_a_label' => 'feel relaxed and friendly', 'option_b_label' => 'are tidy and well-arranged', 'option_c_label' => 'are new and exciting', 'option_d_label' => 'make me think on a deeper level', 'a_side' => 'RL', 'b_side' => 'LL', 'c_side' => 'RU', 'd_side' => 'LU'],
            // Q4
            ['question_text' => 'When working on a task, I prefer to...', 'option_a_label' => 'focus on getting it accurate', 'option_b_label' => 'discuss it with others', 'option_c_label' => 'finish quickly and move on', 'option_d_label' => 'work step by step until it’s done', 'a_side' => 'LU', 'b_side' => 'RL', 'c_side' => 'RU', 'd_side' => 'LL'],
            // Q5
            ['question_text' => 'I work best with people who...', 'option_a_label' => 'plan things effectively', 'option_b_label' => 'give solid, useful information', 'option_c_label' => 'enjoy sharing ideas', 'option_d_label' => 'help build a positive team vibe', 'a_side' => 'LL', 'b_side' => 'LU', 'c_side' => 'RU', 'd_side' => 'RL'],
            // Q6
            ['question_text' => 'If I had to move to a new location, I’d...', 'option_a_label' => 'look at the pros and cons objectively', 'option_b_label' => 'worry about how it might affect my routine', 'option_c_label' => 'think about the new and old people in my life', 'option_d_label' => 'try to see how it fits into my future goals', 'a_side' => 'LU', 'b_side' => 'LL', 'c_side' => 'RL', 'd_side' => 'RU'],
            // Q7
            ['question_text' => 'When I travel, I like to...', 'option_a_label' => 'weigh the pros and cons of a few places', 'option_b_label' => 'have everything planned in advance', 'option_c_label' => 'spend quality time with family or friends', 'option_d_label' => 'go with the flow and be spontaneous', 'a_side' => 'LU', 'b_side' => 'LL', 'c_side' => 'RL', 'd_side' => 'RU'],
            // Q8
            ['question_text' => 'I prefer to process information by...', 'option_a_label' => 'putting it into groups or categories', 'option_b_label' => 'first checking if the facts are accurate', 'option_c_label' => 'asking others what they think', 'option_d_label' => 'linking it to past experiences or ideas', 'a_side' => 'LL', 'b_side' => 'LU', 'c_side' => 'RL', 'd_side' => 'RU'],
            // Q9
            ['question_text' => 'I like to be told...', 'option_a_label' => '“Here are several things you can work on at once”', 'option_b_label' => '“Test it before using it”', 'option_c_label' => '“Talk it through with your colleagues”', 'option_d_label' => '“Be sure the basics are correct”', 'a_side' => 'RU', 'b_side' => 'LU', 'c_side' => 'RL', 'd_side' => 'LL'],
            // Q10
            ['question_text' => 'When I go for a walk, I like to...', 'option_a_label' => 'know how far I’ll be walking', 'option_b_label' => 'go with friends', 'option_c_label' => 'walk where I feel safe', 'option_d_label' => 'take a different route each time', 'a_side' => 'LU', 'b_side' => 'RL', 'c_side' => 'LL', 'd_side' => 'RU'],
            // Q11
            ['question_text' => 'When starting a new project, I prefer to...', 'option_a_label' => 'work on it with others', 'option_b_label' => 'Prefer factual information about the project', 'option_c_label' => 'explore hidden opportunities', 'option_d_label' => 'finish it within a set time frame', 'a_side' => 'RL', 'b_side' => 'LU', 'c_side' => 'RU', 'd_side' => 'LL'],
            // Q12
            ['question_text' => 'During training sessions, I like...', 'option_a_label' => 'a well-prepared and structured talk', 'option_b_label' => 'variety in the way it\'s presented', 'option_c_label' => 'getting notes and structure in advance', 'option_d_label' => 'a calm, easygoing setting', 'a_side' => 'LU', 'b_side' => 'RU', 'c_side' => 'LL', 'd_side' => 'RL'],
            // Q13
            ['question_text' => 'In my job, I’d enjoy a challenge that helps me...', 'option_a_label' => 'design new programs for the team or company', 'option_b_label' => 'assist someone with a complex task', 'option_c_label' => 'create a checklist and track its completion', 'option_d_label' => 'gain knowledge that improves how I work', 'a_side' => 'RU', 'b_side' => 'RL', 'c_side' => 'LL', 'd_side' => 'LU'],
            // Q14
            ['question_text' => 'When visiting somewhere new, I prefer to...', 'option_a_label' => 'study how to get there in detail', 'option_b_label' => 'take a map and follow it carefully', 'option_c_label' => 'ask people for directions', 'option_d_label' => 'get a feel for the area and trust my gut', 'a_side' => 'LU', 'b_side' => 'LL', 'c_side' => 'RL', 'd_side' => 'RU'],
            // Q15
            ['question_text' => 'If I won a large amount of money, I’d...', 'option_a_label' => 'explore what possibilities it could bring', 'option_b_label' => 'celebrate with my friends or family', 'option_c_label' => 'think about ways to invest it', 'option_d_label' => 'see it as financial security for the future', 'a_side' => 'RU', 'b_side' => 'RL', 'c_side' => 'LU', 'd_side' => 'LL'],
            // Q16
            ['question_text' => 'When I listen to a speaker, I like it when they...', 'option_a_label' => 'push me to think outside the box', 'option_b_label' => 'have a clear structure with a beginning, middle, and end', 'option_c_label' => 'show passion and energy for the topic', 'option_d_label' => 'stay focused and on track', 'a_side' => 'RU', 'b_side' => 'LL', 'c_side' => 'RL', 'd_side' => 'LU'],
            // Q17
            ['question_text' => 'I’d prefer to be part of an organisation that focuses on...', 'option_a_label' => 'strategy and innovation', 'option_b_label' => 'efficiency and productivity', 'option_c_label' => 'fairness and strong values', 'option_d_label' => 'sound money management', 'a_side' => 'RU', 'b_side' => 'LL', 'c_side' => 'RL', 'd_side' => 'LU'],
            // Q18
            ['question_text' => 'When reading about an event, I prefer...', 'option_a_label' => 'a broad overview with few details', 'option_b_label' => 'a factual and precise report', 'option_c_label' => 'a step-by-step detailed report', 'option_d_label' => 'a story told with care and empathy', 'a_side' => 'RU', 'b_side' => 'LU', 'c_side' => 'LL', 'd_side' => 'RL'],
            // Q19
            ['question_text' => 'I’d like my friends to describe me as someone who...', 'option_a_label' => 'gets things done', 'option_b_label' => 'always has fresh ideas', 'option_c_label' => 'is caring and thoughtful', 'option_d_label' => 'speaks directly and clearly', 'a_side' => 'LL', 'b_side' => 'RU', 'c_side' => 'RL', 'd_side' => 'LU'],
            // Q20
            ['question_text' => 'I like ideas that are...', 'option_a_label' => 'well thought through', 'option_b_label' => 'put into action', 'option_c_label' => 'discussed with others', 'option_d_label' => 'explored in depth', 'a_side' => 'LU', 'b_side' => 'LL', 'c_side' => 'RL', 'd_side' => 'RU'],
            // Q21
            ['question_text' => 'When thinking about what to do, I’d prefer to...', 'option_a_label' => 'try something totally new', 'option_b_label' => 'understand the facts', 'option_c_label' => 'create a specific step-by-step action plan', 'option_d_label' => 'help resolve a conflict between people', 'a_side' => 'RU', 'b_side' => 'LU', 'c_side' => 'LL', 'd_side' => 'RL'],
            // Q22
            ['question_text' => 'I enjoy spending time with people who...', 'option_a_label' => 'are kind and speak gently', 'option_b_label' => 'know what they want', 'option_c_label' => 'respect time and are punctual', 'option_d_label' => 'are full of imagination and creativity', 'a_side' => 'RL', 'b_side' => 'LU', 'c_side' => 'LL', 'd_side' => 'RU'],
            // Q23
            ['question_text' => 'As a new employee, I’d value...', 'option_a_label' => 'clear and logical guidance', 'option_b_label' => 'being accepted by others', 'option_c_label' => 'growth opportunities', 'option_d_label' => 'organised and efficient leadership', 'a_side' => 'LU', 'b_side' => 'RL', 'c_side' => 'RU', 'd_side' => 'LL'],
            // Q24
            ['question_text' => 'At work, I like to...', 'option_a_label' => 'be fully prepared', 'option_b_label' => 'make fair and balanced decisions', 'option_c_label' => 'look out for my colleagues’ needs', 'option_d_label' => 'explore and be curious', 'a_side' => 'LL', 'b_side' => 'LU', 'c_side' => 'RL', 'd_side' => 'RU'],
            // Q25
            ['question_text' => 'I’d prefer people to describe me as...', 'option_a_label' => 'someone who never slips up', 'option_b_label' => 'warm and kind-hearted', 'option_c_label' => 'hardworking and thorough', 'option_d_label' => 'different and original', 'a_side' => 'LU', 'b_side' => 'RL', 'c_side' => 'LL', 'd_side' => 'RU'],
            // Q26
            ['question_text' => 'I like the saying...', 'option_a_label' => '“Take it apart”', 'option_b_label' => '“Surprise me”', 'option_c_label' => '“Put the team first”', 'option_d_label' => '“Experience teaches us”', 'a_side' => 'LU', 'b_side' => 'RU', 'c_side' => 'RL', 'd_side' => 'LL'],
            // Q27
            ['question_text' => 'When meeting people, I prefer to...', 'option_a_label' => 'find common ground and work together', 'option_b_label' => 'choose words carefully and avoid mistakes', 'option_c_label' => 'give full explanations without leaving anything out', 'option_d_label' => 'talk about future possibilities', 'a_side' => 'RL', 'b_side' => 'LU', 'c_side' => 'LL', 'd_side' => 'RU'],
            // Q28
            ['question_text' => 'My style is...', 'option_a_label' => 'just enough detail to see the bigger picture', 'option_b_label' => 'try it first and see how it goes', 'option_c_label' => 'straight to the point', 'option_d_label' => 'listen and learn from others', 'a_side' => 'RU', 'b_side' => 'LL', 'c_side' => 'LU', 'd_side' => 'RL'],
            // Q29
            ['question_text' => 'I enjoy magazines that...', 'option_a_label' => 'give stats and facts on topics I like', 'option_b_label' => 'offer lots of practical “how-to” tips', 'option_c_label' => 'give insider stories about people', 'option_d_label' => 'surprise me with new and unusual content', 'a_side' => 'LU', 'b_side' => 'LL', 'c_side' => 'RL', 'd_side' => 'RU'],
            // Q30
            ['question_text' => 'When I think about the future, I like to...', 'option_a_label' => 'think in broader terms and not specifics', 'option_b_label' => 'have a clear roadmap', 'option_c_label' => 'be sensible and practical', 'option_d_label' => 'see how it connects with those around me', 'a_side' => 'RU', 'b_side' => 'LL', 'c_side' => 'LU', 'd_side' => 'RL'],
        ];
        
        foreach ($part1Questions as $i => $question) {
            DB::table('paradigm_questions')->insert([
                'template_id' => $templateId,
                'question_text' => $question['question_text'],
                'question_type' => 'part1',
                'option_a_label' => $question['option_a_label'],
                'option_b_label' => $question['option_b_label'],
                'option_c_label' => $question['option_c_label'],
                'option_d_label' => $question['option_d_label'],
                'a_side' => $question['a_side'],
                'b_side' => $question['b_side'],
                'c_side' => $question['c_side'],
                'd_side' => $question['d_side'],
                'assessment_module' => 'paradigm_main',
                'axis' => 'paradigm_main_part1',
                'element_key' => 'paradigm_main_part1_q' . ($i + 1),
                'is_required' => true,
                'display_order' => $i + 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
