<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ParadigmQuestion;

class ParadigmPart6Seeder extends Seeder
{
    /**
     * Seed Part 6: Social, Emotional Intelligence & Relevancy Quotient
     * 
     * SAFE: Only INSERTS new records, does NOT modify existing parts
     * 
     * 3 Sections:
     * - Social Intelligence (SI): 12 questions
     * - Emotional Intelligence (EQ): 20 questions  
     * - Relevancy Quotient (RQ): 12 questions
     * 
     * Scoring: A=3pts, B=2pts, C=1pt
     */
    public function run(): void
    {
        $templateId = 1;
        $displayOrder = 1;
        
        // SECTION 1: SOCIAL INTELLIGENCE (12 Questions)
        $siQuestions = [
            // Understanding Social Cues (Questions 1-3)
            [
                'question_text' => 'You\'re having coffee with a friend who seems distracted.',
                'option_a_label' => 'Ask if they\'re okay',
                'option_b_label' => 'Pause and give them space',
                'option_c_label' => 'Keep talking as if nothing\'s wrong',
                'section' => 'SI',
            ],
            [
                'question_text' => 'You notice someone standing alone at a party.',
                'option_a_label' => 'Go introduce yourself and make them feel welcome',
                'option_b_label' => 'Smile or wave, but keep your distance',
                'option_c_label' => 'Ignore them—they\'re not your responsibility',
                'section' => 'SI',
            ],
            [
                'question_text' => 'Someone makes a sarcastic remark in a meeting.',
                'option_a_label' => 'Acknowledge it calmly and steer the conversation back on track',
                'option_b_label' => 'Laugh it off even if it felt uncomfortable',
                'option_c_label' => 'Say nothing and avoid eye contact',
                'section' => 'SI',
            ],
            // Empathy & Perspective-Taking (Questions 4-6)
            [
                'question_text' => 'A friend is going through a tough time.',
                'option_a_label' => 'Listen with care and let them express themselves',
                'option_b_label' => 'Offer quick advice to fix the issue',
                'option_c_label' => 'Change the subject to avoid awkwardness',
                'section' => 'SI',
            ],
            [
                'question_text' => 'You\'re in a disagreement but understand the other person\'s point.',
                'option_a_label' => 'Seek common ground or a win-win solution',
                'option_b_label' => 'Politely agree to disagree',
                'option_c_label' => 'Stand your ground no matter what',
                'section' => 'SI',
            ],
            [
                'question_text' => 'You walk past a homeless person on the street.',
                'option_a_label' => 'Offer help or acknowledge them with respect',
                'option_b_label' => 'Feel bad but move on',
                'option_c_label' => 'Assume they\'ve made bad life choices',
                'section' => 'SI',
            ],
            // Communication Skills (Questions 7-9)
            [
                'question_text' => 'You have to give a presentation.',
                'option_a_label' => 'Prepare ahead and practice to engage the audience',
                'option_b_label' => 'Read through your notes and hope for the best',
                'option_c_label' => 'Avoid doing it if you can',
                'section' => 'SI',
            ],
            [
                'question_text' => 'You\'re in an argument with your partner.',
                'option_a_label' => 'Express your feelings calmly and listen to theirs',
                'option_b_label' => 'Try to get your point across, even if things get heated',
                'option_c_label' => 'Shut down emotionally and say as little as possible',
                'section' => 'SI',
            ],
            [
                'question_text' => 'You\'re emailing a potential employer.',
                'option_a_label' => 'Use professional language and double-check your message',
                'option_b_label' => 'Keep it casual but polite',
                'option_c_label' => 'Write quickly with slang or emojis',
                'section' => 'SI',
            ],
            // Social Problem-Solving (Questions 10-12)
            [
                'question_text' => 'You see someone being harassed in public.',
                'option_a_label' => 'Step in if it\'s safe or get help immediately',
                'option_b_label' => 'Observe quietly and decide later if it\'s worth acting',
                'option_c_label' => 'Walk away—it\'s not your problem',
                'section' => 'SI',
            ],
            [
                'question_text' => 'Someone is drinking too much at a party.',
                'option_a_label' => 'Make sure they\'re safe and help them get home',
                'option_b_label' => 'Mention it to a friend but don\'t get involved',
                'option_c_label' => 'Laugh or ignore it—it\'s their responsibility',
                'section' => 'SI',
            ],
            [
                'question_text' => 'In a group project, one member isn\'t contributing.',
                'option_a_label' => 'Speak to them directly to resolve it',
                'option_b_label' => 'Pick up the slack to get the job done',
                'option_c_label' => 'Complain to the manager or gossip about them',
                'section' => 'SI',
            ],
        ];

        foreach ($siQuestions as $q) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $q['question_text'],
                'option_a_label' => $q['option_a_label'],
                'option_b_label' => $q['option_b_label'],
                'option_c_label' => $q['option_c_label'],
                'assessment_module' => 'social_intelligence',
                'axis' => 'serq_si',
                'question_type' => 'part6_si',
                'a_side' => '3', // A = 3 points
                'b_side' => '2', // B = 2 points
                'c_side' => '1', // C = 1 point
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // SECTION 2: EMOTIONAL INTELLIGENCE (20 Questions)
        $eqQuestions = [
            // Self-Awareness (Questions 1-5)
            [
                'question_text' => 'You\'re assigned a difficult task at work.',
                'option_a_label' => 'You feel confident you can handle it',
                'option_b_label' => 'You hope you\'ll manage but aren\'t sure',
                'option_c_label' => 'You doubt your ability from the start',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You make a mistake.',
                'option_a_label' => 'You own it and look for ways to improve',
                'option_b_label' => 'You admit it only if someone else notices',
                'option_c_label' => 'You blame something or someone else',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You start feeling frustrated during a conversation.',
                'option_a_label' => 'You recognise it and stay calm',
                'option_b_label' => 'You feel it but aren\'t sure why',
                'option_c_label' => 'You lash out or shut down',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'A friend says your tone came across as harsh.',
                'option_a_label' => 'You reflect and apologise if needed',
                'option_b_label' => 'You explain your intention but don\'t change much',
                'option_c_label' => 'You say they\'re being too sensitive',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You realise you\'re in a bad mood because of someone else\'s energy.',
                'option_a_label' => 'You notice and choose how you respond',
                'option_b_label' => 'You feel off but can\'t pinpoint why',
                'option_c_label' => 'You let their mood ruin yours',
                'section' => 'EQ',
            ],
            // Self-Management (Questions 6-10)
            [
                'question_text' => 'You\'re under pressure with tight deadlines.',
                'option_a_label' => 'You manage your time and stay grounded',
                'option_b_label' => 'You get things done but feel overwhelmed',
                'option_c_label' => 'You get snappy or shut down',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'Someone cuts in line while you\'re waiting.',
                'option_a_label' => 'You stay calm and let it go',
                'option_b_label' => 'You mumble something but move on',
                'option_c_label' => 'You confront them loudly or stew in anger',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You\'re faced with a tough decision.',
                'option_a_label' => 'You evaluate the pros and cons first',
                'option_b_label' => 'You make a quick call based on your gut',
                'option_c_label' => 'You avoid deciding until it\'s too late',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'Someone irritates you during a meeting.',
                'option_a_label' => 'You pause and choose your words wisely',
                'option_b_label' => 'You make a subtle comment',
                'option_c_label' => 'You say something you regret',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'Something\'s been bothering you for days.',
                'option_a_label' => 'You bring it up and discuss it calmly',
                'option_b_label' => 'You keep it in but try to move on',
                'option_c_label' => 'You avoid the topic entirely',
                'section' => 'EQ',
            ],
            // Social Awareness (Questions 11-15)
            [
                'question_text' => 'Your colleague gives you constructive feedback.',
                'option_a_label' => 'You listen and appreciate their input',
                'option_b_label' => 'You nod politely but feel defensive',
                'option_c_label' => 'You shut them down or ignore it',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'A friend seems off during your usual hangout.',
                'option_a_label' => 'You ask how they\'re doing',
                'option_b_label' => 'You wonder but don\'t say anything',
                'option_c_label' => 'You assume they\'re just being weird',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You walk into a tense room.',
                'option_a_label' => 'You quickly sense something\'s wrong',
                'option_b_label' => 'You feel a bit off but can\'t tell why',
                'option_c_label' => 'You don\'t notice anything different',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'Someone is sharing a problem with you.',
                'option_a_label' => 'You listen closely and pick up on what they\'re really saying',
                'option_b_label' => 'You hear their words but miss their emotion',
                'option_c_label' => 'You interrupt or offer quick advice',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You\'re at a gathering with new people.',
                'option_a_label' => 'You strike up friendly conversations with ease',
                'option_b_label' => 'You stick to small talk',
                'option_c_label' => 'You avoid interactions altogether',
                'section' => 'EQ',
            ],
            // Relationship Management (Questions 16-20)
            [
                'question_text' => 'There\'s tension between you and someone you care about.',
                'option_a_label' => 'You address it openly and respectfully',
                'option_b_label' => 'You wait and hope it blows over',
                'option_c_label' => 'You ignore them or act cold',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You need to explain a difficult idea.',
                'option_a_label' => 'You communicate it clearly and check for understanding',
                'option_b_label' => 'You explain it but get frustrated if they don\'t get it',
                'option_c_label' => 'You give up or get vague',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'A colleague is clearly stressed.',
                'option_a_label' => 'You ask how you can support them',
                'option_b_label' => 'You say "Hang in there" and move on',
                'option_c_label' => 'You avoid talking to them',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You\'re involved in a conflict.',
                'option_a_label' => 'You try to understand all sides and find a solution',
                'option_b_label' => 'You defend yourself without fully listening',
                'option_c_label' => 'You argue to win or shut down',
                'section' => 'EQ',
            ],
            [
                'question_text' => 'You want to build a stronger bond with someone.',
                'option_a_label' => 'You take time to understand their interests and needs',
                'option_b_label' => 'You ask surface-level questions',
                'option_c_label' => 'You wait for them to make the first move',
                'section' => 'EQ',
            ],
        ];

        foreach ($eqQuestions as $q) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $q['question_text'],
                'option_a_label' => $q['option_a_label'],
                'option_b_label' => $q['option_b_label'],
                'option_c_label' => $q['option_c_label'],
                'assessment_module' => 'emotional_intelligence',
                'axis' => 'serq_eq',
                'question_type' => 'part6_eq',
                'a_side' => '3',
                'b_side' => '2',
                'c_side' => '1',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // SECTION 3: RELEVANCY QUOTIENT (12 Questions)
        $rqQuestions = [
            // Curiosity & Openness to Change (Questions 1-3)
            [
                'question_text' => 'You hear about a new approach in your field.',
                'option_a_label' => 'You explore it and see how it might apply to your work',
                'option_b_label' => 'You make a mental note to look into it later',
                'option_c_label' => 'You stick to what you already know works',
                'section' => 'RQ',
            ],
            [
                'question_text' => 'You\'re faced with a task that requires learning a new skill.',
                'option_a_label' => 'You dive in and enjoy the challenge',
                'option_b_label' => 'You try, but feel hesitant and unsure',
                'option_c_label' => 'You avoid it or delegate it to someone else',
                'section' => 'RQ',
            ],
            [
                'question_text' => 'A younger colleague introduces a new idea.',
                'option_a_label' => 'You\'re open and ask questions to understand it',
                'option_b_label' => 'You nod politely but prefer your usual way',
                'option_c_label' => 'You dismiss it because they lack experience',
                'section' => 'RQ',
            ],
            // Self-Awareness & Self-Disruption (Questions 4-6)
            [
                'question_text' => 'Someone questions your usual method of doing things.',
                'option_a_label' => 'You reflect and consider how you could improve',
                'option_b_label' => 'You defend your method but stay open to feedback',
                'option_c_label' => 'You feel offended and shut the conversation down',
                'section' => 'RQ',
            ],
            [
                'question_text' => 'You realise your current strategy isn\'t working anymore.',
                'option_a_label' => 'You adapt quickly and try a new approach',
                'option_b_label' => 'You struggle to shift but eventually make changes',
                'option_c_label' => 'You stick with it, hoping it\'ll improve with time',
                'section' => 'RQ',
            ],
            [
                'question_text' => 'You notice you\'re repeating the same mistakes.',
                'option_a_label' => 'You take time to reflect and create new habits',
                'option_b_label' => 'You try to change, but fall back into old patterns',
                'option_c_label' => 'You ignore it and keep doing what\'s familiar',
                'section' => 'RQ',
            ],
            // Responsiveness to Trends & Innovation (Questions 7-9)
            [
                'question_text' => 'Your industry undergoes rapid change.',
                'option_a_label' => 'You stay informed and adjust as needed',
                'option_b_label' => 'You try to keep up but feel behind',
                'option_c_label' => 'You resist change and stick to the old way',
                'section' => 'RQ',
            ],
            [
                'question_text' => 'A new tool or technology is introduced at work.',
                'option_a_label' => 'You learn how to use it and encourage others',
                'option_b_label' => 'You learn the basics but don\'t go deep',
                'option_c_label' => 'You avoid using it unless absolutely necessary',
                'section' => 'RQ',
            ],
            [
                'question_text' => 'You notice your audience/client needs have changed.',
                'option_a_label' => 'You shift your approach to stay relevant',
                'option_b_label' => 'You tweak a few things but keep most the same',
                'option_c_label' => 'You continue using the same strategies as before',
                'section' => 'RQ',
            ],
            // Learning, Unlearning & Relearning (Questions 10-12)
            [
                'question_text' => 'You read something that challenges your beliefs.',
                'option_a_label' => 'You reflect and explore the new perspective',
                'option_b_label' => 'You listen but keep your original stance',
                'option_c_label' => 'You reject it without consideration',
                'section' => 'RQ',
            ],
            [
                'question_text' => 'A system or structure you relied on becomes outdated.',
                'option_a_label' => 'You embrace the opportunity to build something better',
                'option_b_label' => 'You feel uncertain but try to adjust',
                'option_c_label' => 'You resist the change and complain about it',
                'section' => 'RQ',
            ],
            [
                'question_text' => 'You are asked to teach someone a modern method you just learned.',
                'option_a_label' => 'You share it confidently and keep learning as you go',
                'option_b_label' => 'You try your best but still feel unsure',
                'option_c_label' => 'You avoid teaching it because you don\'t feel qualified',
                'section' => 'RQ',
            ],
        ];

        foreach ($rqQuestions as $q) {
            ParadigmQuestion::create([
                'template_id' => $templateId,
                'question_text' => $q['question_text'],
                'option_a_label' => $q['option_a_label'],
                'option_b_label' => $q['option_b_label'],
                'option_c_label' => $q['option_c_label'],
                'assessment_module' => 'relevancy_quotient',
                'axis' => 'serq_rq',
                'question_type' => 'part6_rq',
                'a_side' => '3',
                'b_side' => '2',
                'c_side' => '1',
                'display_order' => $displayOrder++,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $this->command->info('✅ Part 6: Social Intelligence (12), Emotional Intelligence (20), Relevancy Quotient (12) = 44 questions seeded successfully');
    }
}

