<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\ParadigmAssessmentResult;
use Illuminate\Support\Facades\DB;

class RemoveDuplicateParadigmResultsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $email = 'jaslabbert@vodamail.co.za';
        $this->command->info("Checking for duplicates for: $email");

        // 1. Clean up ParadigmAssessmentResult duplicates
        $results = ParadigmAssessmentResult::where('email', $email)
            ->orderBy('created_at', 'asc') // Keep the oldest (first) one
            ->get();

        if ($results->count() > 1) {
            $this->command->info("Found {$results->count()} assessment results. Keeping the first one and deleting the rest.");
            
            // Keep the first one
            $original = $results->shift();
            $this->command->info("Keeping Result ID: {$original->id} (Created: {$original->created_at})");

            // Delete the rest
            foreach ($results as $duplicate) {
                $duplicate->delete();
                $this->command->info("Deleted Result ID: {$duplicate->id} (Created: {$duplicate->created_at})");
            }
        } else {
            $this->command->info("No duplicate assessment results found.");
        }

        // 2. Clean up User duplicates
        $users = User::where('email', $email)
            ->orderBy('created_at', 'asc') // Keep the oldest (first) one
            ->get();

        if ($users->count() > 1) {
            $this->command->info("Found {$users->count()} user records. Keeping the first one and deleting the rest.");

            // Keep the first one
            $originalUser = $users->shift();
            $this->command->info("Keeping User ID: {$originalUser->id} (Created: {$originalUser->created_at})");

            // Delete the rest
            foreach ($users as $duplicateUser) {
                // You might want to reassign related records here if necessary, 
                // but for a simple cleanup we'll just delete.
                // CAUTION: This might cascade delete related data depending on foreign keys.
                try {
                    $duplicateUser->delete();
                    $this->command->info("Deleted User ID: {$duplicateUser->id} (Created: {$duplicateUser->created_at})");
                } catch (\Exception $e) {
                    $this->command->error("Failed to delete User ID: {$duplicateUser->id}. Error: " . $e->getMessage());
                }
            }
        } else {
            $this->command->info("No duplicate user records found.");
        }
    }
}
