<?php
/**
 * PayFast ITN Handler for Sandbox Testing
 * URL: https://your-ngrok-url.ngrok-free.dev/payfast-sandbox-itn.php
 */

// Respond immediately to PayFast
http_response_code(200);
echo "OK";

// Bootstrap Laravel minimally
require __DIR__.'/../vendor/autoload.php';
$app = require_once __DIR__.'/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Log the ITN
\Illuminate\Support\Facades\Log::info('PayFast Sandbox ITN received', ['data' => $_POST]);

// Get transaction data
$transactionId = $_POST['m_payment_id'] ?? null;
$paymentStatus = strtolower($_POST['payment_status'] ?? '');

if (!$transactionId) {
    \Illuminate\Support\Facades\Log::error('PayFast ITN missing transaction ID');
    exit;
}

try {
    // Find the transaction
    $wallet = \Illuminate\Support\Facades\DB::table('wallet_history')
        ->where('transaction_id', $transactionId)
        ->first();
    
    if (!$wallet) {
        \Illuminate\Support\Facades\Log::error('Transaction not found', ['transaction_id' => $transactionId]);
        exit;
    }
    
    // Update status
    if ($paymentStatus === 'complete') {
        \Illuminate\Support\Facades\DB::table('wallet_history')
            ->where('transaction_id', $transactionId)
            ->update(['status' => 'completed']);
        
        \Illuminate\Support\Facades\Log::info('Transaction completed', [
            'transaction_id' => $transactionId,
            'amount' => $wallet->amount,
            'credits' => $wallet->credits
        ]);
    }
    
} catch (\Exception $e) {
    \Illuminate\Support\Facades\Log::error('PayFast ITN processing failed', [
        'error' => $e->getMessage(),
        'transaction_id' => $transactionId
    ]);
}
?>
