<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
	<meta name="description" content="{{ $companyName }} Admin">
	<meta name="keywords" content="admin">
	<meta name="author" content="{{ $companyName }}">
	<meta name="robots" content="noindex, nofollow">
	<title>{{ $companyName }}</title>
	<meta name="csrf-token" content="{{ csrf_token() }}">

	<!-- Favicon -->
	<link rel="shortcut icon" type="image/x-icon" href="{{ $dynamicFavicon }}">

	@php
		$isRTL = isRTL(app()->getLocale());
	@endphp

	@if ($isRTL)
		<link rel="stylesheet" href="{{ asset('assets/css/bootstrap.rtl.min.css') }}">
	@else
		<link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">
	@endif

	<!-- Feather CSS -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/icons/feather/feather.css') }}">

	<!-- Tabler Icon CSS -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/tabler-icons/tabler-icons.css') }}">

	<!-- Daterangepikcer CSS -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/daterangepicker/daterangepicker.css') }}">
	<!-- Dragula CSS -->
	<link rel="stylesheet" href="{{asset('assets/plugins/dragula/css/dragula.min.css')}}">

	<link rel="stylesheet" href="{{asset('https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css')}}">

	<!-- Fontawesome CSS -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/fontawesome/css/fontawesome.min.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/plugins/fontawesome/css/all.min.css') }}">

	<!-- Datetimepicker CSS -->
	<link rel="stylesheet" href="{{ asset('assets/css/bootstrap-datetimepicker.min.css') }}">

	<!-- Owl Carousel CSS -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/owlcarousel/owl.carousel.min.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/plugins/owlcarousel/owl.theme.default.min.css') }}">

	<link rel="stylesheet" href="{{ asset('assets/css/dataTables.bootstrap5.min.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/plugins/select2/css/select2.css') }}">

	<!-- Mobile CSS-->
	<link rel="stylesheet" href="{{ asset('assets/plugins/intltelinput/css/intlTelInput.css') }}">

	<!-- Toastr CSS -->
	<link href="{{ asset('assets/plugins/toastr/toatr.css') }}" rel="stylesheet">

	<!-- bootstrap-tagsinput CSS -->
	<link href="{{ asset('assets/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css') }}" rel="stylesheet">

	<!-- summernote CSS -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/summernote/summernote-bs5.min.css') }}">

	<!-- Boxicons CSS -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/boxicons/css/boxicons.min.css')}}">

	<!-- Fancybox -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/fancybox/jquery.fancybox.min.css')}}">

	<!-- Swiper CSS -->
	<link rel="stylesheet" href="{{ asset('assets/plugins/swiper/swiper.min.css')}}">

	<link rel="stylesheet" href="{{ asset('assets/css/menu-style.css') }}">

	<!-- Main CSS -->
	<link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">

	<!-- Custom CSS -->
	<link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">

</head>

<body data-page="{{ Route::currentRouteName() }}" class="{{ $isRTL ? 'layout-mode-rtl' : '' }}"
	data-lang="{{ app()->getLocale() }}" data-authid="{{ Auth::id() ?? '' }}">
	<div id="language-settings" data-language-id="{{ session('languageId', 'null') }}"></div>
	<div id="datatable_data" data-length_menu="{{ __('lengthMenu') }}" data-info="{{ __('info') }}"
		data-info_empty="{{ __('infoEmpty') }}" data-info_filter="{{ __('infoFiltered') }}"
		data-search="{{ __('search') }}" data-zero_records="{{ __('zeroRecords') }}" data-first="{{ __('first') }}"
		data-last="{{ __('last') }}" data-next="{{ __('next') }}" data-prev="{{ __('previous') }}"></div>

	<!-- Main Wrapper -->
	<div class="main-wrapper">
		@include('admin.partials.header')
		@yield('content')
		@include('admin.partials.footer')
	</div>
	<!-- /Main Wrapper -->
	
	<!-- jQuery -->
	<script src="{{ asset('assets/js/jquery-3.7.1.min.js') }}"></script>

	<!-- jQuery validation -->
	<script src="{{ asset('assets/js/jquery-validation.min.js') }}"></script>
	<script src="{{ asset('assets/js/jquery-validation-additional-methods.min.js') }}"></script>

	<!-- Bootstrap Core JS -->
	<script src="{{ asset('assets/js/bootstrap.bundle.min.js') }}"></script>

	<!-- Daterangepikcer JS -->
	<script src="{{ asset('assets/js/moment.js') }}"></script>
	<script src="{{ asset('assets/plugins/daterangepicker/daterangepicker.js') }}"></script>
	<script src="{{ asset('assets/js/bootstrap-datetimepicker.min.js') }}"></script>

	<!-- Feather Icon JS -->
	<script src="{{ asset('assets/js/feather.min.js') }}"></script>

	<!-- Dragula JS -->
	<script src="{{asset('assets/plugins/dragula/js/dragula.min.js') }}"></script>
	<script src="{{asset('assets/plugins/dragula/js/drag-drop.min.js') }}"></script>
	<script src="{{asset('assets/plugins/dragula/js/draggable-cards.js') }}"></script>

	<script src="{{asset('https://code.jquery.com/ui/1.12.1/jquery-ui.js') }}"></script>

	<!-- Chart JS -->
	<script src="{{ asset('assets/plugins/apexchart/apexcharts.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/apexchart/chart-data.js') }}"></script>

	<!-- Slimscroll JS -->
	<script src="{{ asset('assets/js/jquery.slimscroll.min.js') }}"></script>

	<!-- Owl JS -->
	<script src="{{ asset('assets/plugins/owlcarousel/owl.carousel.min.js') }}"></script>

	<!-- Select2 JS -->
	<script src="{{ asset('assets/plugins/select2/js/select2.min.js') }}"></script>

	<!-- Counter JS -->
	<script src="{{ asset('assets/plugins/countup/jquery.counterup.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/countup/jquery.waypoints.min.js') }}">	</script>

	<!-- Toastr JS -->
	<script src="{{ asset('assets/plugins/toastr/toastr.min.js') }}"></script>

	<!-- Datatable JS -->
	<script src="{{ asset('assets/js/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('assets/js/dataTables.bootstrap5.min.js') }}"></script>

	<!-- Mobile Input -->
	<script src="{{ asset('assets/plugins/intltelinput/js/intlTelInput.js') }}"></script>

	<!-- Firebase removed -->

	<!-- bootstrap-tagsinput JS -->
	<script src="{{ asset('assets/plugins/bootstrap-tagsinput/bootstrap-tagsinput.js') }}"></script>

	@if (request()->routeIs('content.menu-builder'))
		<script src="{{ asset('assets/js/menu-builder.js') }}"></script>
	@endif

	<script src="{{ asset('assets/js/admin-lang-script.js') }}"></script>

	<!-- Firebase script removed -->
	<!-- Custom JS -->
	<script src="{{ asset('assets/js/script.js') }}"></script>

	<script src="{{ asset('assets/js/adminscript.js') }}"></script>
	<script src="{{ asset('assets/js/settingscript.js') }}"></script>

	@if (request()->routeIs('admin.services') || request()->routeIs('admin.addservice') || request()->routeIs('editservice'))
		<script src="{{ asset('assets/js/servicescript.js') }}"></script>
	@endif

	@if (request()->routeIs('admin.servicecategories') || request()->routeIs('admin.form-categories') || request()->routeIs('admin.servicesubcategories'))
		<script src="{{ asset('assets/js/categoryscript.js') }}"></script>
	@endif

	@if (request()->routeIs('admin.productcategories') || request()->routeIs('admin.productsubcategories'))
		<script src="{{ asset('assets/js/productcategory.js') }}"></script>
	@endif

	@if (request()->routeIs('admin.leads') || request()->routeIs('admin.leadsinfo'))
		<script src="{{ asset('assets/js/leadsscript.js') }}"></script>
	@endif

	<!-- summernote JS -->
	<script src="{{ asset('assets/plugins/summernote/summernote-bs5.min.js') }}"></script>
	<!-- Slimscroll JS -->
	<script src="{{ asset('assets/js/jquery.slimscroll.min.js')}}"></script>

	<!-- Swiper JS -->
	<script src="{{ asset('assets/plugins/swiper/swiper.min.js')}}"></script>

	<!-- Sticky Sidebar JS -->
	@if (request()->routeIs('admin.add_page_builder') || request()->routeIs('admin.edit_page_builder'))
		<script src="{{ asset('assets/plugins/theia-sticky-sidebar/ResizeSensor.js')}}"></script>
		<script src="{{ asset('assets/plugins/theia-sticky-sidebar/theia-sticky-sidebar.js')}}"></script>
	@endif

	<!-- FancyBox JS -->
	<script src="{{ asset('assets/plugins/fancybox/jquery.fancybox.min.js')}}"></script>

	<!-- Calendar JS -->
	@if (request()->routeIs('admin.calendar'))
		<script src="{{ asset('assets/plugins/fullcalendar/calendar.js')}}"></script>
		<script src="{{ asset('assets/js/calendarscript.js')}}"></script>
	@endif

	<!-- Custom JS -->
	<script src="{{ asset('assets/js/custom.js') }}"></script>

	<!-- Postal Code Auto-Fill -->
	<script src="{{ asset('assets/js/postal-code-autofill.js') }}"></script>

	<!-- Geo Country Detection -->
	<script src="{{ asset('assets/js/geo-country-detect.js') }}"></script>

	@stack('scripts')

</body>

</html>