@extends('admin.admin')

@section('content')

<div class="page-wrapper">
    <div class="content">
        <div class="d-md-flex d-block align-items-center justify-content-between mb-3">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('Branch Verification') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="javascript:void(0);">{{ __('Branch & Staff Verification') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Branch Verification') }}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="card">
            <div class="card-body p-0 py-3">
                <div class="custom-datatable-filter table-responsive">
                    <table id="loader-table" class="table table-bordered">
                        <thead class="thead-light">
                            <tr>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                                <th><div class="skeleton label-skeleton label-loader"></div></th>
                            </tr>
                        </thead>
                        <tbody>
                            @for($i = 0; $i < 5; $i++)
                            <tr>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                                <td><div class="skeleton data-skeleton data-loader"></div></td>
                            </tr>
                            @endfor
                        </tbody>
                    </table>
                    <table class="table d-none" id="branchVerificationTable">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>{{__('Branch Name')}}</th>
                                <th>{{__('Provider')}}</th>
                                <th>{{__('Documents')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Created On')}}</th>
                                <th>{{__('Action')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- View Branch Modal -->
<div class="modal fade" id="viewBranchModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Branch Verification Details') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="branchDetails">
                    <!-- Branch Image -->
                    <div class="row mb-3" id="branch_image_container" style="display:none;">
                        <div class="col-12 text-center">
                            <img id="branch_image" src="" alt="Branch Image" style="max-width: 200px; max-height: 200px; object-fit: cover; border-radius: 8px;">
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>{{ __('Branch Name') }}:</strong>
                            <p id="branch_name"></p>
                        </div>
                        <div class="col-md-6">
                            <strong>{{ __('Provider') }}:</strong>
                            <p id="provider_name"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>{{ __('Email') }}:</strong>
                            <p id="branch_email"></p>
                        </div>
                        <div class="col-md-6">
                            <strong>{{ __('Phone') }}:</strong>
                            <p id="branch_mobile"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-12">
                            <strong>{{ __('Address') }}:</strong>
                            <p id="branch_address"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <strong>{{ __('City') }}:</strong>
                            <p id="branch_city"></p>
                        </div>
                        <div class="col-md-3">
                            <strong>{{ __('State') }}:</strong>
                            <p id="branch_state"></p>
                        </div>
                        <div class="col-md-3">
                            <strong>{{ __('Country') }}:</strong>
                            <p id="branch_country"></p>
                        </div>
                        <div class="col-md-3">
                            <strong>{{ __('Postal Code') }}:</strong>
                            <p id="branch_postal"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>{{ __('Working Hours') }}:</strong>
                            <p id="working_hours"></p>
                        </div>
                        <div class="col-md-6">
                            <strong>{{ __('Working Days') }}:</strong>
                            <p id="working_days"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-12">
                            <strong>{{ __('Holidays') }}:</strong>
                            <p id="holidays"></p>
                        </div>
                    </div>
                    <hr>
                    <h6>{{ __('Uploaded Documents') }}</h6>
                    <div id="documents_list" class="row"></div>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="current_branch_id">
                <button type="button" class="btn btn-danger" id="rejectBranchBtn">
                    <i class="ti ti-x me-1"></i>{{ __('Reject') }}
                </button>
                <button type="button" class="btn btn-success" id="approveBranchBtn">
                    <i class="ti ti-check me-1"></i>{{ __('Approve') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Rejection Reason Modal -->
<div class="modal fade" id="rejectionReasonModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Rejection Reason') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <textarea class="form-control" id="rejection_reason" rows="4" placeholder="{{ __('Enter reason for rejection') }}" required></textarea>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                <button type="button" class="btn btn-danger" id="confirmRejectBtn">{{ __('Confirm Reject') }}</button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    const table = $('#branchVerificationTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("admin.branch.verification.list") }}',
            type: 'GET'
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'branch_name', name: 'branch_name' },
            { data: 'provider_name', name: 'provider_name' },
            { data: 'documents_count', name: 'documents_count' },
            { data: 'status_badge', name: 'verification_status' },
            { data: 'created_at', name: 'created_at' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        drawCallback: function() {
            $('#loader-table').addClass('d-none');
            $('#branchVerificationTable').removeClass('d-none');
        }
    });

    // View branch details
    $(document).on('click', '.view-branch-btn', function() {
        const branchId = $(this).data('id');
        
        $.ajax({
            url: `/admin/branch-verification/${branchId}/details`,
            method: 'GET',
            success: function(response) {
                $('#current_branch_id').val(response.branch.id);
                $('#branch_name').text(response.branch.branch_name || 'N/A');
                $('#provider_name').text(response.branch.creator ? response.branch.creator.name : 'N/A');
                $('#branch_email').text(response.branch.branch_email || 'N/A');
                $('#branch_mobile').text(response.branch.branch_mobile || 'N/A');
                $('#branch_address').text(response.branch.branch_address || 'N/A');
                $('#branch_city').text(response.city_name);
                $('#branch_state').text(response.state_name);
                $('#branch_country').text(response.country_name);
                $('#branch_postal').text(response.branch.branch_zip || 'N/A');
                
                // Display branch image
                if (response.branch_image_url) {
                    $('#branch_image').attr('src', response.branch_image_url);
                    $('#branch_image_container').show();
                } else {
                    $('#branch_image_container').hide();
                }
                
                // Display working hours
                const startHour = response.branch.start_hour || 'N/A';
                const endHour = response.branch.end_hour || 'N/A';
                $('#working_hours').text(`${startHour} - ${endHour}`);
                
                // Display working days
                if (response.working_days && response.working_days.length > 0) {
                    const days = response.working_days.map(day => day.charAt(0).toUpperCase() + day.slice(1));
                    $('#working_days').text(days.join(', '));
                } else {
                    $('#working_days').text('N/A');
                }
                
                // Display holidays
                if (response.holidays && response.holidays.length > 0) {
                    const holidayList = response.holidays.filter(h => h).join(', ');
                    $('#holidays').text(holidayList || 'N/A');
                } else {
                    $('#holidays').text('N/A');
                }
                
                // Display documents
                let docsHtml = '';
                if (response.documents && response.documents.length > 0) {
                    response.documents.forEach(doc => {
                        const fileExt = doc.name.split('.').pop().toLowerCase();
                        const isImage = ['jpg', 'jpeg', 'png', 'gif', 'webp'].includes(fileExt);
                        
                        docsHtml += `
                            <div class="col-md-4 mb-3">
                                <div class="card">
                                    <div class="card-body text-center">
                                        ${isImage ? 
                                            '<img src="' + doc.url + '" alt="Document" style="max-width: 100%; max-height: 250px; margin-bottom: 10px;">' : 
                                            '<i class="ti ti-file-pdf fs-1 mb-2 text-danger"></i>'}
                                        <p class="small mb-2"><strong>${doc.type}</strong></p>
                                        <p class="small mb-2">${doc.name}</p>
                                        <a href="${doc.url}" target="_blank" class="btn btn-sm btn-primary">
                                            <i class="ti ti-eye me-1"></i>View Full Size
                                        </a>
                                    </div>
                                </div>
                            </div>
                        `;
                    });
                } else {
                    docsHtml = '<div class="col-12"><p class="text-muted">No documents uploaded</p></div>';
                }
                $('#documents_list').html(docsHtml);
                
                // Show modal using Bootstrap 5 syntax
                const modal = new bootstrap.Modal(document.getElementById('viewBranchModal'));
                modal.show();
            },
            error: function(xhr, status, error) {
                console.error('Error loading branch details:', error);
                console.error('Response:', xhr.responseText);
                toastr.error('Failed to load branch details. Please check console for details.');
            }
        });
    });

    // Approve branch
    $('#approveBranchBtn').on('click', function() {
        const branchId = $('#current_branch_id').val();
        
        if (confirm('Are you sure you want to approve this branch?')) {
            $.ajax({
                url: '{{ route("admin.branch.verification.verify") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    branch_id: branchId,
                    action: 'approve'
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                        const modal = bootstrap.Modal.getInstance(document.getElementById('viewBranchModal'));
                        modal.hide();
                        table.ajax.reload();
                    }
                },
                error: function(xhr) {
                    console.error('Error approving branch:', xhr.responseText);
                    toastr.error('Failed to approve branch. Please try again.');
                }
            });
        }
    });

    // Show rejection modal
    $('#rejectBranchBtn').on('click', function() {
        const modal = new bootstrap.Modal(document.getElementById('rejectionReasonModal'));
        modal.show();
    });

    // Confirm rejection
    $('#confirmRejectBtn').on('click', function() {
        const branchId = $('#current_branch_id').val();
        const reason = $('#rejection_reason').val();
        
        if (!reason.trim()) {
            toastr.error('Please enter a rejection reason');
            return;
        }
        
        $.ajax({
            url: '{{ route("admin.branch.verification.verify") }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                branch_id: branchId,
                action: 'reject',
                rejection_reason: reason
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    const rejectModal = bootstrap.Modal.getInstance(document.getElementById('rejectionReasonModal'));
                    rejectModal.hide();
                    const viewModal = bootstrap.Modal.getInstance(document.getElementById('viewBranchModal'));
                    viewModal.hide();
                    $('#rejection_reason').val('');
                    table.ajax.reload();
                }
            },
            error: function(xhr) {
                console.error('Error rejecting branch:', xhr.responseText);
                toastr.error('Failed to reject branch. Please try again.');
            }
        });
    });
});
</script>
@endpush

