@extends('admin.admin')

@section('title', __('Pricing Management'))

@section('content')
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="page-title">{{ __('Pricing Management') }}</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Pricing Management') }}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                    <!-- Tabs -->
                    <ul class="nav nav-tabs mb-3" id="pricingTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="pricing-tab" data-bs-toggle="tab" data-bs-target="#pricing" type="button" role="tab" aria-controls="pricing" aria-selected="true">
                                {{ __('Pricing Management') }}
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="set-price-tab" data-bs-toggle="tab" data-bs-target="#set-price" type="button" role="tab" aria-controls="set-price" aria-selected="false">
                                {{ __('Set Price for User Self-Purchase') }}
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="transactions-tab" data-bs-toggle="tab" data-bs-target="#transactions" type="button" role="tab" aria-controls="transactions" aria-selected="false">
                                {{ __('User Self-Purchased Profiles') }}
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="marketplace-pricing-tab" data-bs-toggle="tab" data-bs-target="#marketplace-pricing" type="button" role="tab" aria-controls="marketplace-pricing" aria-selected="false">
                                {{ __('Marketplace Pricing') }}
                            </button>
                        </li>
                    </ul>
                    
                    <div class="tab-content" id="pricingTabsContent">
                        <!-- Pricing Tab -->
                        <div class="tab-pane fade show active" id="pricing" role="tabpanel" aria-labelledby="pricing-tab">
                            <div class="table-responsive">
                                <table class="table table-striped" id="pricingTable">
                                    <thead>
                                        <tr>
                                            <th style="width: 50%;">{{ __('Template Name') }}</th>
                                            <th style="width: 15%;">{{ __('Current Price') }}</th>
                                            <th style="width: 10%;">{{ __('Currency') }}</th>
                                            <th style="width: 10%;">{{ __('Status') }}</th>
                                            <th style="width: 15%;">{{ __('Actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($templates as $template)
                                        <tr data-template-id="{{ $template->id }}">
                                            <td style="max-width: 400px; word-wrap: break-word; white-space: normal;">
                                                <strong>{{ $template->name }}</strong>
                                                @if($template->description)
                                                <br><small class="text-muted" style="line-height: 1.4; display: block; margin-top: 5px;">{{ Str::limit($template->description, 80) }}</small>
                                                @endif
                                            </td>
                                            <td>
                                                @if($template->pricing && $template->pricing->is_active)
                                                    <span class="price-display">
                                                        @if($template->pricing->price == 0)
                                                            <span class="badge bg-success">{{ __('Free') }}</span>
                                                        @else
                                                            {{ number_format($template->pricing->price, 2) }} Credits
                                                        @endif
                                                    </span>
                                                @else
                                                    <span class="text-muted">{{ __('Not Set') }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($template->pricing && $template->pricing->is_active)
                                                    Credits
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($template->pricing && $template->pricing->is_active)
                                                    <span class="badge bg-success">{{ __('Active') }}</span>
                                                @else
                                                    <span class="badge bg-secondary">{{ __('Inactive') }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-primary edit-pricing" 
                                                        data-template-id="{{ $template->id }}"
                                                        data-template-name="{{ $template->name }}"
                                                        data-current-price="{{ $template->pricing ? $template->pricing->price : 0 }}"
                                                        data-current-currency="{{ $template->pricing ? $template->pricing->currency : 'USD' }}"
                                                        data-current-description="{{ $template->pricing ? $template->pricing->description : '' }}"
                                                        data-current-status="{{ $template->pricing ? $template->pricing->is_active : false }}">
                                                    <i class="ti ti-edit"></i> {{ __('Edit') }}
                                                </button>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <!-- Set Price Tab -->
                        <div class="tab-pane fade" id="set-price" role="tabpanel" aria-labelledby="set-price-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">{{ __('Configure User Self-Purchase Package') }}</h4>
                                        </div>
                                        <div class="card-body">
                                            <form action="{{ route('admin.paradigm.sales.store') }}" method="POST">
                                                @csrf
                                                
                                                <div class="form-group mb-3">
                                                    <label>{{ __('Credits Amount') }} <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" class="form-control" name="credits" value="{{ $package ? $package->credits : '' }}" required>
                                                    <small class="text-muted">{{ __('Price will be calculated automatically (Credits * R17.50).') }}</small>
                                                </div>

                                                <div class="form-group mb-3">
                                                    <label>{{ __('Status') }}</label>
                                                    <div class="status-toggle">
                                                        <input type="checkbox" id="status_self_purchase" class="check" name="is_active" value="1" {{ $package && $package->is_active ? 'checked' : '' }}>
                                                        <label for="status_self_purchase" class="checktoggle">checkbox</label>
                                                    </div>
                                                </div>

                                                <div class="text-end">
                                                    <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">{{ __('Package Details') }}</h4>
                                        </div>
                                        <div class="card-body">
                                            @if($package)
                                                <ul class="list-group">
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        {{ __('Credits') }}
                                                        <span class="badge bg-primary rounded-pill">{{ $package->credits }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        {{ __('Price (ZAR)') }}
                                                        <span class="fw-bold">R{{ number_format($package->final_price_zar, 2) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        {{ __('Status') }}
                                                        <span class="badge bg-{{ $package->is_active ? 'success' : 'danger' }}">
                                                            {{ $package->is_active ? __('Active') : __('Inactive') }}
                                                        </span>
                                                    </li>
                                                </ul>
                                            @else
                                                <p class="text-muted">{{ __('Package not configured yet.') }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Transactions Tab -->
                        <div class="tab-pane fade" id="transactions" role="tabpanel" aria-labelledby="transactions-tab">
                            <div class="table-responsive">
                                <table class="table table-hover table-center mb-0">
                                    <thead>
                                        <tr>
                                            <th>{{ __('Date') }}</th>
                                            <th>{{ __('Client Name') }}</th>
                                            <th>{{ __('Email') }}</th>
                                            <th>{{ __('Template') }}</th>
                                            <th>{{ __('Amount') }}</th>
                                            <th>{{ __('Status') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($transactions as $transaction)
                                            @php
                                                // Get client name - prefer from payment record, then from user
                                                $clientName = 'N/A';
                                                $clientEmail = 'N/A';
                                                
                                                if ($transaction->client_name && $transaction->client_surname) {
                                                    $clientName = trim($transaction->client_name . ' ' . $transaction->client_surname);
                                                } elseif ($transaction->client_name) {
                                                    $clientName = $transaction->client_name;
                                                }
                                                
                                                if ($transaction->client_email) {
                                                    $clientEmail = $transaction->client_email;
                                                }
                                                
                                                // Fallback to client user if payment doesn't have name
                                                if ($clientName === 'N/A' || empty($clientName)) {
                                                    $client = $transaction->client;
                                                    if ($client) {
                                                        if ($client->userDetail) {
                                                            $firstName = $client->userDetail->first_name ?? '';
                                                            $lastName = $client->userDetail->last_name ?? '';
                                                            $clientName = trim($firstName . ' ' . $lastName) ?: $client->name;
                                                        } else {
                                                            $clientName = $client->name;
                                                        }
                                                        if (empty($clientEmail) || $clientEmail === 'N/A') {
                                                            $clientEmail = $client->email;
                                                        }
                                                    }
                                                }
                                                
                                                // Get template name
                                                $templateName = $transaction->template ? $transaction->template->name : 'Paradigm Profiles™';
                                            @endphp
                                            <tr>
                                                <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                                <td>{{ $clientName }}</td>
                                                <td>{{ $clientEmail }}</td>
                                                <td>{{ $templateName }}</td>
                                                <td>
                                                    @if($transaction->amount > 0)
                                                        {{ number_format($transaction->amount, 2) }} {{ $transaction->currency }}
                                                    @else
                                                        {{ __('Free') }}
                                                    @endif
                                                </td>
                                                <td>
                                                    <span class="badge bg-{{ $transaction->status == 'paid' || $transaction->status == 'free' ? 'success' : 'warning' }}">
                                                        {{ ucfirst($transaction->status) }}
                                                    </span>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center">{{ __('No self-purchased profiles found') }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-3">
                                {{ $transactions->links() }}
                            </div>
                        </div>
                        
                        <!-- Marketplace Pricing Tab -->
                        <div class="tab-pane fade" id="marketplace-pricing" role="tabpanel" aria-labelledby="marketplace-pricing-tab">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5>{{ __('Marketplace Pricing Rules') }}</h5>
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#marketplacePricingModal">
                                    <i class="ti ti-plus me-1"></i>{{ __('Add Pricing Rule') }}
                                </button>
                            </div>
                            
                            <div class="table-responsive">
                                <table class="table table-hover table-center mb-0">
                                    <thead>
                                        <tr>
                                            <th>{{ __('Rule Name') }}</th>
                                            <th>{{ __('Paradigm Type') }}</th>
                                            <th>{{ __('Score Range') }}</th>
                                            <th>{{ __('Price (Credits)') }}</th>
                                            <th>{{ __('Status') }}</th>
                                            <th>{{ __('Actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($marketplaceRules ?? [] as $rule)
                                            <tr>
                                                <td>{{ $rule->rule_name }}</td>
                                                <td>{{ $rule->paradigm_type ?? __('All Types') }}</td>
                                                <td>
                                                    @if($rule->min_score || $rule->max_score)
                                                        {{ $rule->min_score ?? '0' }} - {{ $rule->max_score ?? '∞' }}
                                                    @else
                                                        {{ __('All Scores') }}
                                                    @endif
                                                </td>
                                                <td>{{ number_format($rule->price_credits, 2) }}</td>
                                                <td>
                                                    <span class="badge bg-{{ $rule->is_active ? 'success' : 'secondary' }}">
                                                        {{ $rule->is_active ? __('Active') : __('Inactive') }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-danger delete-rule" data-rule-id="{{ $rule->id }}">
                                                        <i class="ti ti-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center">{{ __('No pricing rules found') }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Marketplace Pricing Modal -->
<div class="modal fade" id="marketplacePricingModal" tabindex="-1" aria-labelledby="marketplacePricingModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="marketplacePricingModalLabel">{{ __('Add Pricing Rule') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="marketplacePricingForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('Rule Name') }} <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="rule_name" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">{{ __('Paradigm Type') }}</label>
                        <select class="form-control" name="paradigm_type">
                            <option value="">{{ __('All Types') }}</option>
                            <option value="The Analyst">The Analyst (LU - Left Upper)</option>
                            <option value="The Organiser">The Organiser (LL - Left Lower)</option>
                            <option value="The Visionary">The Visionary (RU - Right Upper)</option>
                            <option value="The Helper">The Helper (RL - Right Lower)</option>
                            <option value="The Specialist">The Specialist (LL + LU)</option>
                            <option value="The Strategist">The Strategist (LU + RU)</option>
                            <option value="The Advisor">The Advisor (LU + RL)</option>
                            <option value="The Architect">The Architect (LL + RU)</option>
                            <option value="The Harmoniser">The Harmoniser (LL + RL)</option>
                            <option value="The Creator">The Creator (RL + RU)</option>
                            <option value="The Innovator">The Innovator (LL + LU + RU)</option>
                            <option value="The Stabiliser">The Stabiliser (LL + LU + RL)</option>
                            <option value="The Integrator">The Integrator (LU + RL + RU)</option>
                            <option value="The Vision Builder">The Vision Builder (LL + RL + RU)</option>
                            <option value="The Whole-Brain Thinker">The Whole-Brain Thinker (All Frames)</option>
                        </select>
                        <small class="text-muted">{{ __('Leave empty to apply to all types. Types are based on dominant brain frames (LU, LL, RU, RL).') }}</small>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ __('Min Score') }}</label>
                                <input type="number" class="form-control" name="min_score" step="0.01" min="0">
                                <small class="text-muted">{{ __('Optional') }}</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ __('Max Score') }}</label>
                                <input type="number" class="form-control" name="max_score" step="0.01" min="0">
                                <small class="text-muted">{{ __('Optional') }}</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">{{ __('Price (Credits)') }} <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="price_credits" step="0.01" min="0.01" required>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_active" id="marketplace_is_active" value="1" checked>
                            <label class="form-check-label" for="marketplace_is_active">
                                {{ __('Active') }}
                            </label>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">{{ __('Sort Order') }}</label>
                        <input type="number" class="form-control" name="sort_order" value="0" min="0">
                        <small class="text-muted">{{ __('Lower numbers have higher priority') }}</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Save Rule') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Pricing Modal -->
<div class="modal fade" id="pricingModal" tabindex="-1" aria-labelledby="pricingModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="pricingModalLabel">{{ __('Set Pricing') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="pricingForm">
                <div class="modal-body">
                    <input type="hidden" id="template_id" name="template_id">
                    
                    <div class="mb-3">
                        <label class="form-label">{{ __('Template') }}</label>
                        <input type="text" class="form-control" id="template_name" readonly>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">{{ __('Price') }} <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="price" name="price" 
                                   min="0" step="0.01" required>
                            <select class="form-select" id="currency" name="currency" style="max-width: 100px;">
                                <option value="USD">USD</option>
                                <option value="EUR">EUR</option>
                                <option value="GBP">GBP</option>
                                <option value="CAD">CAD</option>
                            </select>
                        </div>
                        <small class="form-text text-muted">{{ __('Set to 0 for free assessments') }}</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">{{ __('Description') }}</label>
                        <textarea class="form-control" id="description" name="description" rows="3" 
                                  placeholder="{{ __('Optional description for this pricing') }}"></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                            <label class="form-check-label" for="is_active">
                                {{ __('Active') }}
                            </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Save Pricing') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Edit pricing button click
    $('.edit-pricing').on('click', function() {
        const templateId = $(this).data('template-id');
        const templateName = $(this).data('template-name');
        const currentPrice = $(this).data('current-price');
        const currentCurrency = $(this).data('current-currency');
        const currentDescription = $(this).data('current-description');
        const currentStatus = $(this).data('current-status');
        
        $('#template_id').val(templateId);
        $('#template_name').val(templateName);
        $('#price').val(currentPrice);
        $('#currency').val(currentCurrency);
        $('#description').val(currentDescription);
        $('#is_active').prop('checked', currentStatus);
        
        $('#pricingModal').modal('show');
    });
    
    // Form submission
    $('#pricingForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = {
            template_id: $('#template_id').val(),
            price: $('#price').val(),
            currency: $('#currency').val(),
            description: $('#description').val(),
            is_active: $('#is_active').is(':checked') ? 1 : 0
        };
        
        $.ajax({
            url: '{{ route("admin.paradigm.pricing.store") }}',
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    $('#pricingModal').modal('hide');
                    location.reload();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                if (response && response.message) {
                    toastr.error(response.message);
                } else {
                    toastr.error('{{ __("An error occurred while saving pricing") }}');
                }
            }
        });
    });
    
    // Marketplace Pricing Form
    $('#marketplacePricingForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = {
            rule_name: $('input[name="rule_name"]').val(),
            paradigm_type: $('select[name="paradigm_type"]').val() || null,
            min_score: $('input[name="min_score"]').val() || null,
            max_score: $('input[name="max_score"]').val() || null,
            price_credits: $('input[name="price_credits"]').val(),
            is_active: $('#marketplace_is_active').is(':checked') ? 1 : 0,
            sort_order: $('input[name="sort_order"]').val() || 0
        };
        
        $.ajax({
            url: '{{ route("admin.paradigm.pricing.marketplace.store") }}',
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    $('#marketplacePricingModal').modal('hide');
                    $('#marketplacePricingForm')[0].reset();
                    location.reload();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                if (response && response.message) {
                    toastr.error(response.message);
                } else {
                    toastr.error('{{ __("An error occurred while saving pricing rule") }}');
                }
            }
        });
    });
    
    // Delete Marketplace Pricing Rule
    $(document).on('click', '.delete-rule', function() {
        const ruleId = $(this).data('rule-id');
        
        if (!confirm('{{ __("Are you sure you want to delete this pricing rule?") }}')) {
            return;
        }
        
        $.ajax({
            url: '{{ route("admin.paradigm.pricing.marketplace.delete", ":id") }}'.replace(':id', ruleId),
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    location.reload();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                if (response && response.message) {
                    toastr.error(response.message);
                } else {
                    toastr.error('{{ __("An error occurred while deleting pricing rule") }}');
                }
            }
        });
    });
});
</script>
@endpush
